/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hummer.im.HMR;
import com.hummer.im.chatroom.Challenges;
import com.hummer.im.chatroom.ChatRoomInfo;
import com.hummer.im.id.ChatRoom;
import com.hummer.im.id.User;
import com.hummer.im.shared.completion.Completion;
import com.hummer.im.shared.completion.CompletionArg;
import java.util.List;
import java.util.Map;

public interface ChatRoomService
extends HMR.Service {
    public void createChatRoom(@NonNull ChatRoomInfo var1, @NonNull CompletionArg<ChatRoom> var2);

    public void deleteChatRoom(@NonNull ChatRoom var1, @Nullable CompletionArg<ChatRoom> var2);

    public void join(@NonNull ChatRoom var1, @NonNull Challenges.JoiningCompletion var2);

    public void leave(@NonNull ChatRoom var1, @Nullable Completion var2);

    public void kick(@NonNull ChatRoom var1, @NonNull User var2, @Nullable Map<EKickInfo, String> var3, @NonNull CompletionArg<ChatRoom> var4);

    public void addRole(@NonNull ChatRoom var1, @NonNull User var2, @NonNull String var3, @NonNull CompletionArg<ChatRoom> var4);

    public void removeRole(@NonNull ChatRoom var1, @NonNull User var2, @NonNull String var3, @NonNull CompletionArg<ChatRoom> var4);

    public void fetchMembers(@NonNull ChatRoom var1, int var2, int var3, @NonNull CompletionArg<List<User>> var4);

    public void fetchRoleMembers(@NonNull ChatRoom var1, boolean var2, @NonNull CompletionArg<Map<String, List<User>>> var3);

    public void fetchBasicInfo(@NonNull ChatRoom var1, @NonNull CompletionArg<ChatRoomInfo> var2);

    public void changeBasicInfo(@NonNull ChatRoom var1, @NonNull Map<ChatRoomInfo.BasicInfoType, String> var2, @NonNull Completion var3);

    public void addListener(@NonNull ChatRoomListener var1);

    public void removeListener(@NonNull ChatRoomListener var1);

    public void addMemberListener(@NonNull ChatRoomMembterListener var1);

    public void removeMemberListener(@NonNull ChatRoomMembterListener var1);

    public static interface ChatRoomMembterListener {
        default public void onMemberJoin(@NonNull ChatRoom chatRoom, @NonNull List<User> list) {
        }

        default public void onMemberLeave(@NonNull ChatRoom chatRoom, @NonNull List<User> list) {
        }

        default public void onMemberCount(@NonNull ChatRoom chatRoom, int n) {
        }

        default public void onRoleAdded(@NonNull ChatRoom chatRoom, @NonNull String string, @NonNull User user, @NonNull User user2) {
        }

        default public void onRoleRemoved(@NonNull ChatRoom chatRoom, @NonNull String string, @NonNull User user, @NonNull User user2) {
        }

        default public void onMemberKicked(@NonNull ChatRoom chatRoom, @NonNull User user, @NonNull List<User> list, @NonNull String string) {
        }
    }

    public static interface ChatRoomListener {
        default public void onBasicInfoChanged(@NonNull ChatRoom chatRoom, @NonNull Map<ChatRoomInfo.BasicInfoType, String> map) {
        }

        default public void onDeleteChatRoom(@NonNull ChatRoom chatRoom, @NonNull User user) {
        }
    }

    public static final class DefaultRoleType {
        public static final String admin = "admin";
        public static final String owner = "owner";
    }

    public static enum EKickInfo {
        Time,
        Reason;

    }
}

