/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.channel._internals;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.google.protobuf.ByteString;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.Objects;
import com.hummer.im._internals.chatsvc.ChatServiceImpl;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.mq.Source;
import com.hummer.im._internals.proto.ChannelProto;
import com.hummer.im._internals.proto.Im;
import com.hummer.im._internals.proto.Push;
import com.hummer.im._internals.proto.Signal;
import com.hummer.im._internals.shared.DispatchQueue;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im._internals.shared.statis.TextUtils;
import com.hummer.im.channel.ChannelService;
import com.hummer.im.channel._internals.rpc.RPCDeleteUserInfo;
import com.hummer.im.channel._internals.rpc.RPCFetchMembers;
import com.hummer.im.channel._internals.rpc.RPCFetchMembersByAttr;
import com.hummer.im.channel._internals.rpc.RPCJoinChannel;
import com.hummer.im.channel._internals.rpc.RPCLeaveChannel;
import com.hummer.im.channel._internals.rpc.RPCSendBroadcast;
import com.hummer.im.channel._internals.rpc.RPCSetUserInfo;
import com.hummer.im.model.Channel;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.id.User;
import com.hummer.im.model.signal.SendingOptions;
import com.hummer.im.service.Channel;
import com.hummer.im.service.MQService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ChannelServiceImpl
implements ServiceProvider.Service,
ChannelService {
    public static final String TAG = "ChannelServiceImpl";
    private static final String OFFLINE_DURATION_KEY = "props_offline_check_duration";
    private static long kRejoinConditionGap = 55000L;
    private static final long kReferenceValue = 946656000L;
    private final HashSet<ChannelService.Listener> mListeners = new HashSet();
    private final HashSet<Channel> mJoinedChannel = new HashSet();
    private Channel.StateChangedListener mChannelStateListener;
    private long mInitialTimeInterval = 0L;
    private static final String GROUP_URI = "service_api_gateway/cim.proto.PushService.UnreliableIMPushGroupSysMsg";

    private void registerChatServiceExtensions() {
        ChatServiceImpl.registerParserExtension((ChatServiceImpl.ParserExtension)new ChatServiceImpl.ParserExtension(){

            public String toString() {
                return ChannelServiceImpl.TAG;
            }

            public Message parseMessage(String string, String string2, byte[] byArray) {
                String string3 = string + '/' + string2;
                if (Objects.equals((Object)string3, (Object)ChannelServiceImpl.GROUP_URI)) {
                    if (ChannelServiceImpl.this.isChannelTimeOut()) {
                        Log.i((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("parseMessage").msg((Object)"Ignore the join msg for heartbeat timeout"));
                        return null;
                    }
                    try {
                        Push.UnreliableIMPushGroupSysMsgRequest unreliableIMPushGroupSysMsgRequest = (Push.UnreliableIMPushGroupSysMsgRequest)((Push.UnreliableIMPushGroupSysMsgRequest.Builder)Push.UnreliableIMPushGroupSysMsgRequest.newBuilder().mergeFrom(byArray)).build();
                        if (unreliableIMPushGroupSysMsgRequest.getEnvName() != null && !unreliableIMPushGroupSysMsgRequest.getEnvName().isEmpty()) {
                            HMRContext.Region region = HMRContext.Region.make((String)(unreliableIMPushGroupSysMsgRequest.getRegion() + "/" + unreliableIMPushGroupSysMsgRequest.getEnvType() + "/" + unreliableIMPushGroupSysMsgRequest.getEnvName()));
                            String string4 = HMRContext.region.toString();
                            String string5 = region.toString();
                            if (!Objects.equals((Object)string5, (Object)string4)) {
                                Log.i((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("parseMessage").msg((Object)"Ignored parse of different env").info("localEnv", (Object)string4).info("remoteEnv", (Object)string5));
                                return null;
                            }
                        }
                        ChannelServiceImpl.this.parseChannelMessage(unreliableIMPushGroupSysMsgRequest.getMsg().getContent(), unreliableIMPushGroupSysMsgRequest.getMsg().getTimestamp(), ChannelServiceImpl.this.channelNameFromTopic(unreliableIMPushGroupSysMsgRequest.getTopic()));
                    }
                    catch (Throwable throwable) {
                        Log.e((String)ChannelServiceImpl.TAG, (Object)Trace.once((Object)"Failed parsing UnreliableIMPushGroupSysMsgRequest").info("Exception", (Object)throwable));
                    }
                }
                return null;
            }

            public Message parseMessage(Im.Msg msg, Source source) {
                try {
                    if (msg.getAction() == Im.Action.kNotifyUinfoChange) {
                        ChannelServiceImpl.this.parseMemberInfoChangeNotify(msg.getContent());
                    } else if (msg.getActionValue() == 1000004) {
                        ChannelServiceImpl.this.parseUserChangeNotify(msg.getContent());
                    } else if (msg.getAction() == Im.Action.kNotifySignalMessage) {
                        ChannelServiceImpl.this.parseChannelMessage(msg.getContent(), msg.getTimestamp(), source);
                    }
                }
                catch (Throwable throwable) {
                    Log.e((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("parse").info("action", (Object)msg.getAction()).info("msg", (Object)msg.getContent()).info("exception", (Object)throwable.getMessage()));
                }
                return null;
            }
        });
    }

    private void parseChannelMessage(ByteString byteString, long l, Source source) {
        if (source.getMode() instanceof Source.Shared) {
            if (this.isChannelTimeOut()) {
                Log.i((String)TAG, (Object)Trace.once().method("parseChannelMessage").msg((Object)"Ignore the join msg for heartbeat timeout"));
                return;
            }
            String string = this.channelNameFromTopic(source.getMode().topicName());
            this.parseChannelMessage(byteString, l, string);
        }
    }

    private void parseChannelMessage(ByteString byteString, long l, String string) {
        Channel channel = new Channel(string);
        if (TextUtils.isBlank((CharSequence)string) || !this.mJoinedChannel.contains(channel)) {
            Log.i((String)TAG, (Object)Trace.once().method("parseChannelMessage").msg("user[%d] already leave the channel[%s]", new Object[]{HMR.getMe().getId(), channel.getName()}));
            return;
        }
        Signal.SignalMessage signalMessage = (Signal.SignalMessage)((Signal.SignalMessage.Builder)Signal.SignalMessage.newBuilder().mergeFrom(byteString)).build();
        com.hummer.im.model.signal.Message message = new com.hummer.im.model.signal.Message(signalMessage.getType(), signalMessage.getContent().toByteArray());
        message.setServerAcceptedTs(l);
        message.setAppExtras(signalMessage.getExtensionsMap());
        this.notifyReceivedMessage(channel, message, new User(signalMessage.getFromUid()));
    }

    private void notifyReceivedMessage(final @NonNull Channel channel, final @NonNull com.hummer.im.model.signal.Message message, final @NonNull User user) {
        DispatchQueue.main.async("ChannelService::notifyReceivedMessage", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Log.i((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("notifyReceivedMessage").info("message.type", (Object)message.getType()).info("message.ts", (Object)message.getServerAcceptedTs()).info("fromUser", (Object)user.getId()).info("channel", (Object)channel.getName()));
                HashSet hashSet = ChannelServiceImpl.this.mListeners;
                synchronized (hashSet) {
                    HashSet hashSet2 = (HashSet)ChannelServiceImpl.this.mListeners.clone();
                    for (ChannelService.Listener listener : hashSet2) {
                        listener.onReceivedMessage(channel, message, user);
                    }
                }
            }
        });
    }

    private void parseUserChangeNotify(ByteString byteString) {
        if (this.isChannelTimeOut()) {
            Log.i((String)TAG, (Object)Trace.once().method("parseUserChangeNotify").msg((Object)"Ignore the join msg for heartbeat timeout"));
            return;
        }
        ChannelProto.NotifyUserStatusChange notifyUserStatusChange = (ChannelProto.NotifyUserStatusChange)((ChannelProto.NotifyUserStatusChange.Builder)ChannelProto.NotifyUserStatusChange.newBuilder().mergeFrom(byteString)).build();
        Channel channel = new Channel(notifyUserStatusChange.getGroupId());
        if (!this.mJoinedChannel.contains(channel)) {
            Log.i((String)TAG, (Object)Trace.once().method("parseUserChangeNotify").info("logId", (Object)notifyUserStatusChange.getLogId()).msg("user[%d] already leave the channel[%s]", new Object[]{HMR.getMe().getId(), channel.getName()}));
            return;
        }
        ArrayList<User> arrayList = new ArrayList<User>();
        ArrayList<User> arrayList2 = new ArrayList<User>();
        if (notifyUserStatusChange.getJoinuidsCount() > 0) {
            for (Long l : notifyUserStatusChange.getJoinuidsList()) {
                arrayList.add(new User(l.longValue()));
            }
            this.notifyUsersJoined(channel, arrayList);
        }
        if (notifyUserStatusChange.getLeaveuidsCount() > 0) {
            for (Long l : notifyUserStatusChange.getLeaveuidsList()) {
                arrayList2.add(new User(l.longValue()));
            }
            this.notifyUsersLeaved(channel, arrayList2);
        }
    }

    private void parseMemberInfoChangeNotify(ByteString byteString) {
        if (this.isChannelTimeOut()) {
            Log.i((String)TAG, (Object)Trace.once().method("parseMemberInfoChangeNotify").msg((Object)"Ignore the join msg for heartbeat timeout"));
            return;
        }
        Signal.NotifyUinfoChange notifyUinfoChange = (Signal.NotifyUinfoChange)((Signal.NotifyUinfoChange.Builder)Signal.NotifyUinfoChange.newBuilder().mergeFrom(byteString)).build();
        Channel channel = new Channel(notifyUinfoChange.getGroupId());
        if (!this.mJoinedChannel.contains(channel)) {
            Log.i((String)TAG, (Object)Trace.once().method("Ignore the join msg for heartbeat timeout").info("groupId", (Object)notifyUinfoChange.getGroupId()));
            return;
        }
        if (Objects.equals((Object)notifyUinfoChange.getOpType(), (Object)Signal.NotifyUinfoChange.OpType.kOpSet)) {
            this.notifyUserInfoUpdate(channel, new User(notifyUinfoChange.getUid()), notifyUinfoChange.getInfosMap());
        } else if (Objects.equals((Object)notifyUinfoChange.getOpType(), (Object)Signal.NotifyUinfoChange.OpType.kOpDel)) {
            this.notifyUserInfoDelete(channel, new User(notifyUinfoChange.getUid()), notifyUinfoChange.getInfosMap().keySet());
        } else if (notifyUinfoChange.getOpType().equals((Object)Signal.NotifyUinfoChange.OpType.kOpUpdate)) {
            Log.w((String)TAG, (Object)Trace.once().method("parseMemberInfoChangeNotify").msg("the operator type[%s] is not parse", new Object[]{notifyUinfoChange.getOpType()}));
        } else {
            Log.w((String)TAG, (Object)Trace.once().method("parseMemberInfoChangeNotify").msg("the operator type[%s] is not exist", new Object[]{notifyUinfoChange.getOpType()}));
        }
    }

    private void notifyUsersLeaved(final @NonNull Channel channel, final @NonNull List<User> list) {
        DispatchQueue.main.async("ChannelServiceImpl::notifyUserLeaved", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Log.i((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("notifyUsersLeaved").info("channel", (Object)channel.getName()).info("users", (Object)list));
                HashSet hashSet = ChannelServiceImpl.this.mListeners;
                synchronized (hashSet) {
                    HashSet hashSet2 = (HashSet)ChannelServiceImpl.this.mListeners.clone();
                    for (ChannelService.Listener listener : hashSet2) {
                        listener.onUsersLeaved(channel, list);
                    }
                }
            }
        });
    }

    private void notifyUsersJoined(final @NonNull Channel channel, final @NonNull List<User> list) {
        DispatchQueue.main.async("ChannelService::notifyUserJoined", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Log.i((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("notifyUsersJoined").info("channel", (Object)channel.getName()).info("users", (Object)list));
                HashSet hashSet = ChannelServiceImpl.this.mListeners;
                synchronized (hashSet) {
                    HashSet hashSet2 = (HashSet)ChannelServiceImpl.this.mListeners.clone();
                    for (ChannelService.Listener listener : hashSet2) {
                        listener.onUsersJoined(channel, list);
                    }
                }
            }
        });
    }

    private void notifyUserInfoUpdate(final @NonNull Channel channel, final @NonNull User user, final @Nullable Map<String, String> map) {
        DispatchQueue.main.async("ChannelService::notifyMemberInfoUpdate", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Log.i((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("notifyUserInfoUpdate").info("channel", (Object)channel.getName()).info("user", (Object)user.getId()).info("info", (Object)map));
                HashSet hashSet = ChannelServiceImpl.this.mListeners;
                synchronized (hashSet) {
                    HashSet hashSet2 = (HashSet)ChannelServiceImpl.this.mListeners.clone();
                    for (ChannelService.Listener listener : hashSet2) {
                        listener.onUserInfoSet(channel, user, map);
                    }
                }
            }
        });
    }

    private void notifyUserInfoDelete(final @NonNull Channel channel, final @NonNull User user, final @Nullable Set<String> set) {
        DispatchQueue.main.async("ChannelService::notifyUserInfoDelete", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Log.i((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("notifyUserInfoDelete").info("user", (Object)user.getId()).info("channel", (Object)channel.getName()));
                HashSet hashSet = ChannelServiceImpl.this.mListeners;
                synchronized (hashSet) {
                    HashSet hashSet2 = (HashSet)ChannelServiceImpl.this.mListeners.clone();
                    for (ChannelService.Listener listener : hashSet2) {
                        listener.onUserInfoRemove(channel, user, set);
                    }
                }
            }
        });
    }

    private String getTopic(String string) {
        return String.format(Locale.US, "SignalService/%s", string);
    }

    private static long djbHash(String string) {
        String string2 = Base64.encodeToString((byte[])string.getBytes(), (int)2);
        long l = 5381L;
        for (int i = 0; i < string2.length(); ++i) {
            long l2 = l << 5 & 0xFFFFFFFFL;
            l = (l2 + l & 0xFFFFFFFFL) + (long)string2.charAt(i);
            l &= 0xFFFFFFFFL;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leaveChannelIfNeed() {
        if (!this.isChannelTimeOut()) {
            Log.i((String)TAG, (Object)"leaveChannelIfNeed return");
            return;
        }
        if (this.mJoinedChannel.size() > 0) {
            Log.i((String)TAG, (Object)"Leave all channel for offline");
            HashSet<Channel> hashSet = this.mJoinedChannel;
            synchronized (hashSet) {
                HashSet hashSet2 = (HashSet)this.mJoinedChannel.clone();
                ArrayList<User> arrayList = new ArrayList<User>();
                arrayList.add(HMR.getMe());
                for (Channel channel : hashSet2) {
                    String string = this.getTopic(channel.getName());
                    ((MQService)HMR.getService(MQService.class)).removeSource((MQService.Source)new Source((Source.Mode)new Source.Shared(ChannelServiceImpl.djbHash(string), string)));
                    this.mJoinedChannel.remove(channel);
                    this.notifyUsersLeaved(channel, arrayList);
                }
            }
        }
    }

    private boolean isChannelTimeOut() {
        long l = System.currentTimeMillis();
        return this.mInitialTimeInterval > 946656000L && l - this.mInitialTimeInterval >= kRejoinConditionGap;
    }

    private void recordInitialTimeIntervalIfNeeded() {
        if (this.mInitialTimeInterval < 946656000L) {
            this.mInitialTimeInterval = System.currentTimeMillis();
        }
    }

    private void resetInitialTimeInterval() {
        this.mInitialTimeInterval = 0L;
    }

    private void prepareChannel() {
        if (this.mChannelStateListener != null) {
            Log.e((String)TAG, (Object)Trace.once().method("prepareChannel").info("mChannelStateListener exception", null));
            return;
        }
        this.mChannelStateListener = new Channel.StateChangedListener(){

            public void onChannelConnected() {
                HMRContext.work.async("ChannelService::onChannelConnected", new Runnable(){

                    @Override
                    public void run() {
                        Log.w((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("onChannelConnected"));
                        ChannelServiceImpl.this.leaveChannelIfNeed();
                        ChannelServiceImpl.this.resetInitialTimeInterval();
                    }
                });
            }

            public void onChannelDisconnected() {
                HMRContext.work.async("ChannelService::onChannelDisconnected", new Runnable(){

                    @Override
                    public void run() {
                        Log.w((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("onChannelDisconnected"));
                        ChannelServiceImpl.this.recordInitialTimeIntervalIfNeeded();
                    }
                });
            }
        };
        ((com.hummer.im.service.Channel)HMR.getService(com.hummer.im.service.Channel.class)).addStateListener(this.mChannelStateListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void teardownChannel() {
        ((com.hummer.im.service.Channel)HMR.getService(com.hummer.im.service.Channel.class)).removeStateListener(this.mChannelStateListener);
        if (this.mJoinedChannel.size() > 0) {
            HashSet<Channel> hashSet = this.mJoinedChannel;
            synchronized (hashSet) {
                for (Channel channel : this.mJoinedChannel) {
                    ((com.hummer.im.service.Channel)HMR.getService(com.hummer.im.service.Channel.class)).run((Channel.RPC)new RPCLeaveChannel(channel.getName(), null, null));
                    String string = this.getTopic(channel.getName());
                    ((MQService)HMR.getService(MQService.class)).removeSource((MQService.Source)new Source((Source.Mode)new Source.Shared(ChannelServiceImpl.djbHash(string), string)));
                }
            }
            this.mJoinedChannel.clear();
        }
        this.mChannelStateListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ChannelService.Listener listener) {
        HashSet<ChannelService.Listener> hashSet = this.mListeners;
        synchronized (hashSet) {
            this.mListeners.add(listener);
        }
        Log.i((String)TAG, (Object)Trace.once().method("addListener").info("name", (Object)listener.getClass().getSimpleName()).info("size", (Object)this.mListeners.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ChannelService.Listener listener) {
        HashSet<ChannelService.Listener> hashSet = this.mListeners;
        synchronized (hashSet) {
            this.mListeners.remove(listener);
        }
        Log.i((String)TAG, (Object)Trace.once().method("removeListener").info("name", (Object)listener.getClass().getSimpleName()).info("size", (Object)this.mListeners.size()));
    }

    @Override
    public void joinChannel(final @NonNull Channel channel, @Nullable Map<String, String> map, final @Nullable HMR.Completion completion) {
        Log.i((String)TAG, (Object)Trace.once().method("joinChannel").info("channel", (Object)channel.getName()));
        RichCompletion richCompletion = new RichCompletion(completion, "ChannelService::joinChannel");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        ((com.hummer.im.service.Channel)HMR.getService(com.hummer.im.service.Channel.class)).run((Channel.RPC)new RPCJoinChannel(channel.getName(), map, (RichCompletionArg<Map<String, String>>)new RichCompletionArg((HMR.CompletionArg)new HMR.CompletionArg<Map<String, String>>(){

            public void onSuccess(Map<String, String> map) {
                Log.i((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("joinChannel Done").info("channel", (Object)channel.getName()).info("extras", map));
                String string = map.get(ChannelServiceImpl.OFFLINE_DURATION_KEY);
                if (TextUtils.isNotBlank((CharSequence)string)) {
                    kRejoinConditionGap = (Long.valueOf(string) - 5L) * 1000L;
                }
                HMRContext.work.async("", new Runnable(){

                    @Override
                    public void run() {
                        String string = ChannelServiceImpl.this.getTopic(channel.getName());
                        ((MQService)HMR.getService(MQService.class)).addSource((MQService.Source)new Source((Source.Mode)new Source.Shared(ChannelServiceImpl.djbHash(string), string, MQService.FetchStrategy.IgnoreBefore)));
                        ChannelServiceImpl.this.mJoinedChannel.add(channel);
                    }
                });
                if (completion != null) {
                    completion.onSuccess();
                }
            }

            public void onFailed(Error error) {
                Log.i((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("joinChannel fail").info("channel", (Object)channel));
                if (completion != null) {
                    completion.onFailed(error);
                }
            }
        }, "")));
    }

    @Override
    public void leaveChannel(final @NonNull Channel channel, final @Nullable HMR.Completion completion) {
        Log.i((String)TAG, (Object)Trace.once().method("leaveChannel").info("channel", (Object)channel.getName()));
        RichCompletion richCompletion = new RichCompletion(completion, "ChannelService::leaveChannel");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        ((com.hummer.im.service.Channel)HMR.getService(com.hummer.im.service.Channel.class)).run((Channel.RPC)new RPCLeaveChannel(channel.getName(), null, new RichCompletion(new HMR.Completion(){

            public void onSuccess() {
                Log.i((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("leaveChannel Done").info("channel", (Object)channel.getName()));
                HMRContext.work.async("", new Runnable(){

                    @Override
                    public void run() {
                        String string = ChannelServiceImpl.this.getTopic(channel.getName());
                        ((MQService)HMR.getService(MQService.class)).removeSource((MQService.Source)new Source((Source.Mode)new Source.Shared(ChannelServiceImpl.djbHash(string), string)));
                        ChannelServiceImpl.this.mJoinedChannel.remove(channel);
                    }
                });
                if (completion != null) {
                    completion.onSuccess();
                }
            }

            public void onFailed(Error error) {
                Log.i((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("leaveChannel fail").info("channel", (Object)channel.getName()).info("error", (Object)error.toString()));
                if (completion != null) {
                    completion.onFailed(error);
                }
            }
        }, "")));
    }

    @Override
    public void fetchMembers(@NonNull Channel channel, @Nullable HMR.CompletionArg<List<User>> completionArg) {
        RichCompletionArg richCompletionArg = new RichCompletionArg(completionArg, "ChannelService::fetchMembers");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once().method("fetchMembers").info("channel", (Object)channel.getName()));
        ((com.hummer.im.service.Channel)HMR.getService(com.hummer.im.service.Channel.class)).run((Channel.RPC)new RPCFetchMembers(channel.getName(), (RichCompletionArg<List<User>>)richCompletionArg));
    }

    @Override
    public void fetchMembers(@NonNull Channel channel, @NonNull String string, @NonNull String string2, @Nullable HMR.CompletionArg<List<User>> completionArg) {
        RichCompletionArg richCompletionArg = new RichCompletionArg(completionArg, "ChannelService::fetchMembersByAttr");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once().method("fetchMembersByAttr").info("channel", (Object)channel.getName()).info("key", (Object)string).info("value", (Object)string2));
        ((com.hummer.im.service.Channel)HMR.getService(com.hummer.im.service.Channel.class)).run((Channel.RPC)new RPCFetchMembersByAttr(channel.getName(), string, string2, (RichCompletionArg<List<User>>)richCompletionArg));
    }

    @Override
    public void setUserInfo(@NonNull Channel channel, @NonNull Map<String, String> map, @Nullable HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "ChannelService::setUserInfo");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once().method("setUserInfo").info("channel", (Object)channel.getName()).info("infoMap", map));
        ((com.hummer.im.service.Channel)HMR.getService(com.hummer.im.service.Channel.class)).run((Channel.RPC)new RPCSetUserInfo(channel.getName(), map, richCompletion));
    }

    @Override
    public void removeUserInfoByKeys(@NonNull Channel channel, @NonNull Set<String> set, @Nullable HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "ChannelService::removeUserInfoByKeys");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once().method("deleteUserAttrByKeys").info("channel", (Object)channel.getName()).info("keys", set));
        ((com.hummer.im.service.Channel)HMR.getService(com.hummer.im.service.Channel.class)).run((Channel.RPC)new RPCDeleteUserInfo(channel.getName(), set, richCompletion));
    }

    @Override
    public void send(@NonNull Channel channel, @NonNull com.hummer.im.model.signal.Message message, @NonNull SendingOptions sendingOptions, @NonNull HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        ((com.hummer.im.service.Channel)HMR.getService(com.hummer.im.service.Channel.class)).run((Channel.RPC)new RPCSendBroadcast(channel.getName(), message.getType(), new String(message.getData()), !sendingOptions.isUnreliable(), richCompletion));
    }

    private String channelNameFromTopic(String string) {
        if (string == null) {
            Log.e((String)TAG, (Object)Trace.once().method("channelNameFromTopic").info("topic", (Object)"null"));
            return null;
        }
        String[] stringArray = string.split("/");
        if (stringArray.length < 2) {
            Log.e((String)TAG, (Object)Trace.once().method("channelNameFromTopic").info("topic", (Object)"length exception"));
            return null;
        }
        return stringArray[1];
    }

    public Class[] staticDependencies() {
        return new Class[0];
    }

    public Class[] inherentDynamicDependencies() {
        return new Class[]{com.hummer.im.service.Channel.class};
    }

    public Class[] plantingDynamicDependencies() {
        return new Class[0];
    }

    public void initService() {
        this.registerChatServiceExtensions();
    }

    public void openService(@NonNull RichCompletion richCompletion) {
        this.prepareChannel();
        CompletionUtils.dispatchSuccess((RichCompletion)richCompletion);
    }

    public void closeService() {
        this.teardownChannel();
        this.resetInitialTimeInterval();
    }
}

