package com.hummer._internals.yyp.packet;


import com.hummer._internals.log.Log;

import java.util.Locale;

public class Receiver extends Header {

    public static final String TAG = "Receiver";

    private byte[] mBytes = null;

    public Receiver(byte[] bytes) {
        mBytes = bytes;
    }

    public void parseHeader() {
        if (mBytes == null || mBytes.length <= 10) {
            Log.i(TAG, String.format(Locale.US, "Receiver parseHeader err, param err"));
            return;
        }

        Unpack up = new Unpack(mBytes, 0, mBytes.length);
        length = up.popUint32();
        uri = up.popUint32();
        resCode = up.popUint16();
    }

    public boolean unmarshallWrap(Marshallable m) {
        if (mBytes == null || mBytes.length <= 10) {
            Log.i(TAG, String.format("Receiver unmarshallWrap err, param err"));
            return false;
        }

        Unpack up = new Unpack(mBytes, 0, mBytes.length);
        length = up.popUint32();
        uri = up.popUint32();
        resCode = up.popUint16();
        m.unmarshall(up);

        return true;
    }

    public boolean unmarshallWrap2(Marshallable m) {
        if (mBytes == null || mBytes.length == 0) {
            Log.i(TAG, String.format("Receiver unmarshallWrap2 err, param err"));
            return false;
        }

        Unpack up = new Unpack(mBytes, 0, mBytes.length);
        m.unmarshall(up);

        return true;
    }
}
