package com.hummer._internals.yyp.packet;

import java.util.Map;
import java.util.Set;

public class MarshalContainer {

    public static void marshalMapStringString(Pack pack, Map<String, String> map) {
        pack.push(new Uint32(map.size()));
        for (String key : map.keySet()) {
            pack.push(key);
            pack.push(map.get(key));
        }
    }

    public static void marshalMapStringUint32(Pack pack, Map<String, Uint32> map) {
        pack.push(new Uint32(map.size()));
        for (String key : map.keySet()) {
            pack.push(key);
            pack.push(map.get(key));
        }
    }

    public static void marshalSetString(Pack pack, Set<String> set) {
        pack.push(new Uint32(set.size()));
        for (String key : set) {
            pack.push(key);
        }
    }

}
