package com.hummer._internals.utility;

import android.content.SharedPreferences;

import java.util.concurrent.atomic.AtomicLong;

import static android.content.Context.MODE_PRIVATE;

/**
 * requestId 生成器
 *
 * @author hummer组
 */
public final class RequestIdBuilder {
    private static AtomicLong requestSeqId = new AtomicLong(0L);
    private static AtomicLong requestSeqIdCached = new AtomicLong(0L);

    private final static long REQUEST_SEQ_ID_REFRESH_INTERNAL = 1000L;
    private final static String REQUEST_SEQ_ID_CACHE_KEY = "com.hummer.seqId";

    private static final SharedPreferences STORAGE
            = HMRContext.getAppContext().getSharedPreferences(REQUEST_SEQ_ID_CACHE_KEY, MODE_PRIVATE);

    public static long generateRequestId() {
        if (requestSeqId.get() == 0) {
            requestSeqId.set(restoreSeqIdCached());
        }

        if (requestSeqId.incrementAndGet() >= requestSeqIdCached.get()) {
            refreshCache();
        }

        return requestSeqId.get();
    }

    private static long restoreSeqIdCached() {
        long storeSeqId;
        synchronized (STORAGE) {
            storeSeqId = STORAGE.getLong(REQUEST_SEQ_ID_CACHE_KEY, 0);
            requestSeqIdCached.set(storeSeqId);

            refreshCache();
        }

        return storeSeqId;
    }

    private static void refreshCache() {
        synchronized (STORAGE) {
            requestSeqIdCached.set(requestSeqIdCached.get() + REQUEST_SEQ_ID_REFRESH_INTERNAL);

            SharedPreferences storage
                    = HMRContext.getAppContext().getSharedPreferences(REQUEST_SEQ_ID_CACHE_KEY, MODE_PRIVATE);
            SharedPreferences.Editor editor = storage.edit();
            editor.putLong(REQUEST_SEQ_ID_CACHE_KEY, requestSeqIdCached.get());
            editor.apply();
        }
    }
}
