package com.hummer._internals.utility;

import android.content.Context;

import com.hummer._internals.log.Log;
import com.hummer._internals.log.trace.Trace;

import java.util.HashSet;
import java.util.Set;

class ReflectionExt {

    // 对加载模块作hardcode处理，避免第一次启动耗时过多造成ANR
    // 此做法还需优化，缺点在于：
    // 1. 分模块引用时，会由于找不到模块实现而打印出exception
    // 2. 新增模块时，需手动添加配置
    private static String[] allClassNames = {
            "com.hummer._internals.SPCoreModuleLoader",
            "com.hummer.rts._internals.SPRTSModuleLoader"
    };

    public interface Filter {
        boolean shouldAccept(String className);
    }

    @SuppressWarnings("SameParameterValue")
    static Set<Class<?>> loadClasses(
            Context context,
            String cacheVersion,
            String packageName,
            Class<?> classInterface,
            Filter filter) {
        Set<Class<?>> loadedClasses = new HashSet<>();

        // 从类名加载出类
        for (String className : allClassNames) {
            if (className.startsWith(packageName) && filter.shouldAccept(className)) {
                try {
                    Class<?> clazz = Class.forName(className);
                    if (!clazz.isInterface() && classInterface.isAssignableFrom(clazz)) {
                        loadedClasses.add(clazz);
                    }
                } catch (Exception e) {
                    Log.e(TAG, Trace.method("loadClasses")
                            .msg("error"));
                }
            }
        }

        return loadedClasses;
    }

    private static final String TAG = "ReflectionExt";
}