package com.hummer._internals.utility;

public final class Objects {

    /**
     * To check whether if two objects are equals to each other. This is an upward compat for API 19.
     *
     * @return when two are equals, return true, otherwise false
     */
    public static boolean equals(Object lhs, Object rhs) {
        boolean bothNull = (lhs == null && rhs == null);
        boolean bothNotNull = (lhs != null && rhs != null);

        return bothNull || (bothNotNull && lhs.equals(rhs));
    }
}

