package com.hummer._internals.utility;

import com.hummer.Error;
import com.hummer._internals.log.Log;
import com.hummer._internals.log.trace.Trace;

public final class CompletionUtils {

    public static void dispatchSuccess(RichCompletion completion) {
        if (completion != null) {
            completion.dispatchSuccess();
        }
    }

    public static void dispatchFailure(RichCompletion completion, Error error) {
        if (completion != null) {
            completion.dispatchFailure(error);
        }
    }

    public static <T> void dispatchSuccess(RichCompletionArg<T> completion, T result) {
        if (completion != null) {
            completion.dispatchSuccess(result);
        } else {
            Log.i("CompletionUtils", Trace.method("dispatchSuccess")
                    .msg("dispatchQueue async, success completion = null"));
        }
    }

    public static <T> void dispatchFailure(RichCompletionArg<T> completion, Error error) {
        if (completion != null) {
            completion.dispatchFailure(error);
        } else {
            Log.i("CompletionUtils", Trace.method("dispatchFailure")
                    .msg("dispatchQueue async, failure completion = null"));
        }
    }
}
