package com.hummer._internals.user;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.HMR;
import com.hummer._internals.shared.AsciiTable;
import com.hummer._internals.utility.HMRContext;
import com.hummer._internals.utility.ServiceProvider;
import com.hummer._internals.utility.CompletionUtils;
import com.hummer._internals.utility.RichCompletion;
import com.hummer._internals.channel.Channel;

import java.util.Set;

public final class UserServiceImpl implements UserService, ServiceProvider.Service {

    @Override
    public void initService() {
    }

    @Override
    public void deInitService() {

    }

    @Override
    public Class[] staticDependencies() {
        return new Class[]{Channel.class};
    }

    @Override
    public Class[] inherentDynamicDependencies() {
        return new Class[0];
    }

    @Override
    public Class[] plantingDynamicDependencies() {
        return new Class[0];
    }

    @Override
    public void openService(@NonNull RichCompletion completion) {
        showOpenMessage();

        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public void closeService() {
        UserServiceImpl.this.tags = null;
    }

    @Override
    public void setTags(@Nullable Set<String> tags, @Nullable final RichCompletion completion) {
        HMR.getService(Channel.class).run(new RPCSetUserTags(tags, completion));
    }

    private static void showOpenMessage() {
        HMRContext.Region env = HMRContext.region;

        AsciiTable.log(40, "Open", new String[][]{
                {"area", env.area},
                {"type", env.type},
                {"name", env.name},
                {"uid", String.valueOf(HMR.getMe())},
        });
    }

    private Set<String> tags;
}
