package com.hummer._internals.report.statis;

import java.security.NoSuchAlgorithmException;

public class TextUtils {

    // 用来将字节转换成 16 进制表示的字符
    private static final char[] hexDigits = {
            '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String bytes2hex(byte[] data) {
        char[] str = new char[data.length * 2];
        int k = 0;
        for (int i = 0; i < data.length; i++) {
            byte byte0 = data[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xf]; // 取字节中高 4 位的数字转换,
            str[k++] = hexDigits[byte0 & 0xf]; // 取字节中低 4 位的数字转换
        }
        return new String(str);
    }

    public static String length2DecimalChar(int length) {
        //String.format()在国外某些语言系统格式化数字会出现阿拉伯语
        String lenStr = format8length(length);
        return lenStr;
    }

    private static String format8length(int len) {
        StringBuffer sb = new StringBuffer(8);
        int r = 8 - (len + "").length();
        while (r-- > 0) {
            sb.append(0);
        }
        sb.append(len);
        return sb.toString();
    }

    private static final ThreadLocal<java.security.MessageDigest> MD5_DIGEST
            = new ThreadLocal<java.security.MessageDigest>() {
        @Override
        protected java.security.MessageDigest initialValue() {
            try {
                return java.security.MessageDigest.getInstance("MD5");
            } catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public static byte[] md5byte(byte[] source) {
        java.security.MessageDigest md = MD5_DIGEST.get();
        md.reset();
        md.update(source);
        // MD5 的计算结果是一个 128 位的长整数
        byte[] tmp = md.digest();
        return tmp;
    }

    /**
     * <p>Checks if a CharSequence is whitespace, empty ("") or null.</p>
     *
     * <pre>
     * StringUtils.isBlank(null)      = true
     * StringUtils.isBlank("")        = true
     * StringUtils.isBlank(" ")       = true
     * StringUtils.isBlank("bob")     = false
     * StringUtils.isBlank("  bob  ") = false
     * </pre>
     *
     * @param cs  the CharSequence to check, may be null
     * @return {@code true} if the CharSequence is null, empty or whitespace
     */
    public static boolean isBlank(final CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; i++) {
            if (!Character.isWhitespace(cs.charAt(i))) {
                return false;
            }
        }
        return true;
    }

    public static boolean isNotBlank(final CharSequence cs) {
        return !isBlank(cs);
    }

    /**
     * <p>Checks if a CharSequence is empty ("") or null.</p>
     *
     * <pre>
     * StringUtils.isEmpty(null)      = true
     * StringUtils.isEmpty("")        = true
     * StringUtils.isEmpty(" ")       = false
     * StringUtils.isEmpty("bob")     = false
     * StringUtils.isEmpty("  bob  ") = false
     * </pre>
     *
     * @param cs  the CharSequence to check, may be null
     * @return {@code true} if the CharSequence is empty or null
     */
    public static boolean isEmpty(final CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(final CharSequence cs) {
        return !isEmpty(cs);
    }

}
