package com.hummer._internals.report.statis;

import com.hummer._internals.report.HiidoReporter;
import com.hummer._internals.log.Log;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;

/**
 * Created by WuWangchun on 2017/6/30.
 */

public class MetricsCount implements IJsonSerialize, Cloneable {
    private int scode;
    private String uri;
    private String counterName;
    private long value;
    private int invokeCount;

    public MetricsCount(int scode, String uri, String counterName) {
        this.scode = scode;
        this.uri = uri;
        this.counterName = counterName;
    }

    public int getInvokeCount() {
        return invokeCount;
    }

    public long getValue() {
        return value;
    }

    synchronized public void count(long value, int invoke) {
        this.value += value;
        this.invokeCount += invoke;
    }


    @Override
    public JSONObject toJson() {
        long va, in;
        synchronized (this) {
            va = value;
            in = invokeCount;
        }
        if (va == 0 && in == 0) {
            return null;
        }
        try {
            JSONObject obj = new JSONObject();
            obj.put("scode", scode);
            obj.put("uri", URLEncoder.encode(uri, "utf-8"));
            obj.put("counterName", URLEncoder.encode(counterName, "utf-8"));
            obj.put("value", va);
            obj.put("invokecount", (int) in);
            return obj;
        } catch (JSONException e) {
            Log.i(HiidoReporter.TAG, String.format(Locale.US, "report ex:%s", e.getLocalizedMessage()));
        } catch (UnsupportedEncodingException e) {
            Log.i(HiidoReporter.TAG, String.format(Locale.US, "report ex:%s", e.getLocalizedMessage()));
        }
        return null;
    }

    public String getKey() {
        return String.format("%d&%s&%s", scode, uri, counterName);
    }

    @Override
    protected Object clone() {
        MetricsCount counter = new MetricsCount(scode, uri, counterName);
        counter.value = value;
        counter.invokeCount = invokeCount;
        return counter;

    }
}
