package com.hummer._internals.mq;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.Error;
import com.hummer._internals.proto.Location;
import com.hummer._internals.utility.HMRContext;
import com.hummer._internals.utility.IMRPC;
import com.hummer._internals.utility.CompletionUtils;
import com.hummer._internals.utility.RichCompletion;

public class RPCReportUserRegion extends IMRPC<Location.SetUserRegionRequest,
        Location.SetUserRegionRequest.Builder,
        Location.SetUserRegionResponse> {

    private final RichCompletion completion;

    public RPCReportUserRegion(RichCompletion completion) {
        this.completion = completion;
    }

    @Override
    public String getHummerFunction() {
        return "SetUserRegion";
    }

    @Override
    public void buildHummerRequest(@NonNull Location.SetUserRegionRequest.Builder builder) throws Throwable {
        builder.setRegion(HMRContext.region.area).build().toByteArray();
    }

    @Override
    public void handleHummerSuccess(@NonNull Location.SetUserRegionResponse res) throws Throwable {
        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public void handleHummerError(@Nullable Location.SetUserRegionResponse res, @NonNull Error error) {
        CompletionUtils.dispatchFailure(completion, error);
    }
}
