package com.hummer._internals.mq;


import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.Error;
import com.hummer._internals.log.trace.Trace;
import com.hummer._internals.proto.User;
import com.hummer._internals.shared.StringChain;
import com.hummer._internals.utility.CompletionUtils;
import com.hummer._internals.utility.IMRPC;
import com.hummer._internals.utility.RichCompletion;

public class RPCReportSharedSeqId extends IMRPC<User.SetMaxAcquiredGroupSeqIDRequest,
        User.SetMaxAcquiredGroupSeqIDRequest.Builder,
        User.SetMaxAcquiredGroupSeqIDResponse> {

    public static final String TAG = "RPCReportSharedSeqId";
    private final Trace.Flow flow = new Trace.Flow();

    private final int queueId;
    private final String topic;
    private final String region;
    private final long groupId;
    private final long seqId;
    private final RichCompletion completion;

    public RPCReportSharedSeqId(int queueId,
                                String topic,
                                String region,
                                long groupId,
                                long seqId,
                                RichCompletion completion) {
        this.queueId = queueId;
        this.topic = topic;
        this.region = region;
        this.groupId = groupId;
        this.seqId = seqId;
        this.completion = completion;
    }

    @Override
    public long getLogId() {
        return flow.logId;
    }


    @Override
    public String getHummerFunction() {
        return "SetMaxAcquiredGroupSeqID";
    }

    @Override
    public void buildHummerRequest(@NonNull User.SetMaxAcquiredGroupSeqIDRequest.Builder builder) throws Throwable {
        builder.setGroupId(groupId)
                .setTopic(topic == null ? "" : topic)
                .setGroupRegion(region)
                .setSeqId(seqId)
                .setQueueId(queueId)
                .build().toByteArray();
    }

    @Override
    public void handleHummerSuccess(@NonNull User.SetMaxAcquiredGroupSeqIDResponse res) throws Throwable {
        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public void handleHummerError(@Nullable User.SetMaxAcquiredGroupSeqIDResponse res, @NonNull Error error) {
        CompletionUtils.dispatchFailure(completion, error);
    }

    @Override
    public String describeHummerResponse(@NonNull User.SetMaxAcquiredGroupSeqIDResponse res) {
        return new StringChain().acceptNullElements()
                .add("code", res.getCode())
                .add("desc", res.getMsg())
                .toString();
    }
}
