package com.hummer._internals.mq;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.Error;
import com.hummer._internals.utility.IMRPC;
import com.hummer._internals.log.trace.Trace;
import com.hummer._internals.proto.User;
import com.hummer._internals.shared.StringChain;
import com.hummer._internals.utility.RichCompletion;
import com.hummer._internals.utility.CompletionUtils;

public class RPCReportPrivateSeqId extends IMRPC<User.SetMaxAcquiredSeqIDRequest,
        User.SetMaxAcquiredSeqIDRequest.Builder, User.SetMaxAcquiredSeqIDResponse> {

    public static final String TAG = "RPCReportPrivateSeqId";
    private final Trace.Flow flow = new Trace.Flow();
    private final int queueId;
    private final long seqId;
    private final String topic;
    private final RichCompletion completion;

    public RPCReportPrivateSeqId(int queueId, String topic, long seqId, RichCompletion completion) {
        this.queueId = queueId;
        this.topic = topic;
        this.seqId = seqId;
        this.completion = completion;
    }

    @Override
    public long getLogId() {
        return flow.logId;
    }

    @Override
    public String getHummerFunction() {
        return "SetMaxAcquiredSeqID";
    }

    @Override
    public void buildHummerRequest(@NonNull User.SetMaxAcquiredSeqIDRequest.Builder builder) throws Throwable {
        builder.setSeqId(seqId)
                .setTopic(topic == null ? "" : topic)
                .setQueueId(this.queueId)
                .build().toByteArray();
    }

    @Override
    public void handleHummerSuccess(@NonNull User.SetMaxAcquiredSeqIDResponse res) throws Throwable {
        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public void handleHummerError(@Nullable User.SetMaxAcquiredSeqIDResponse res, @NonNull Error error) {
        CompletionUtils.dispatchFailure(completion, error);
    }

    @Override
    public String describeHummerResponse(@NonNull User.SetMaxAcquiredSeqIDResponse res) {
        return new StringChain().acceptNullElements()
                .add("code", res.getCode())
                .add("desc", res.getMsg())
                .toString();
    }
}

