package com.hummer._internals.mq;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.Error;
import com.hummer._internals.utility.IMRPC;
import com.hummer._internals.log.trace.Trace;
import com.hummer._internals.proto.Pull;
import com.hummer._internals.shared.StringChain;
import com.hummer._internals.utility.CompletionUtils;
import com.hummer._internals.utility.RichCompletionArg;

public class RPCPullSharedMessages extends IMRPC<Pull.PullGroupSysMsgRequest,
        Pull.PullGroupSysMsgRequest.Builder, Pull.PullGroupSysMsgResponse> {

    public static final String TAG = "RPCPullSharedMessages";
    private final Trace.Flow flow = new Trace.Flow();
    private final int queueId;
    private final long groupId;
    private final String topic;
    private final boolean isInitialDrain;
    private final long seqId;
    private final int count;
    private final String region;
    private final RichCompletionArg<RPCPullingResponse> completion;

    public RPCPullSharedMessages(int queueId,
                                 long groupId,
                                 String topic,
                                 String region,
                                 long startSeqId,
                                 int count,
                                 boolean isInitialDrain,
                                 RichCompletionArg<RPCPullingResponse> completion) {
        this.queueId = queueId;
        this.isInitialDrain = isInitialDrain;
        this.groupId = groupId;
        this.topic = topic;
        this.region = region;
        this.seqId = startSeqId;
        this.count = count;
        this.completion = completion;
    }

    @Override
    public long getLogId() {
        return flow.logId;
    }

    @Override
    public String getHummerFunction() {
        return "PullGroupSysMsg";
    }

    @Override
    public void buildHummerRequest(@NonNull Pull.PullGroupSysMsgRequest.Builder builder) throws Throwable {
        builder.setGroupId(groupId)
                .setTopic(topic)
                .setExclusiveStartSeqId(seqId)
                .setLimit(count)
                .setStatisDeliveryDelay(!isInitialDrain)
                .setQueueId(queueId)
                .setGroupRegion(region)
                .build().toByteArray();
    }

    @Override
    public void handleHummerSuccess(@NonNull Pull.PullGroupSysMsgResponse res) throws Throwable {
        // 进行明确的语义转换，0实际上是表示没有seqId
        final Long maxSeqId = res.getMaxSeqId() > 0 ? res.getMaxSeqId() : null;
        CompletionUtils.dispatchSuccess(completion,
                new RPCPullingResponse(res.getMsgsList(), res.getHasMore(), maxSeqId));
    }

    @Override
    public void handleHummerError(@Nullable Pull.PullGroupSysMsgResponse res, @NonNull Error error) {
        CompletionUtils.dispatchFailure(completion, error);
    }

    @Override
    public String describeHummerResponse(@NonNull Pull.PullGroupSysMsgResponse res) {
        return new StringChain().acceptNullElements()
                .add("code", res.getCode())
                .add("desc", res.getMsg())
                .toString();
    }
}

