package com.hummer._internals.mq;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.Error;
import com.hummer._internals.utility.HMRContext;
import com.hummer._internals.utility.IMRPC;
import com.hummer._internals.proto.Msg;
import com.hummer._internals.utility.CompletionUtils;
import com.hummer._internals.utility.RichCompletionArg;

public class RPCGetQueueConfig extends IMRPC<Msg.GetQueueConfigRequest,
        Msg.GetQueueConfigRequest.Builder,
        Msg.GetQueueConfigResponse> {

    private final RichCompletionArg<Integer> completion;

    public RPCGetQueueConfig(RichCompletionArg<Integer> completion) {
        this.completion = completion;
    }

    @Override
    public String getHummerFunction() {
        return "GetQueueConfig";
    }
    @Override
    public void buildHummerRequest(@NonNull Msg.GetQueueConfigRequest.Builder builder) throws Throwable {
        builder.setRegion(HMRContext.region.toString()).build().toByteArray();
    }

    @Override
    public void handleHummerSuccess(@NonNull Msg.GetQueueConfigResponse res) throws Throwable {
        CompletionUtils.dispatchSuccess(completion, res.getQueueCount());
    }

    @Override
    public void handleHummerError(@Nullable Msg.GetQueueConfigResponse res, @NonNull Error error) {
        CompletionUtils.dispatchFailure(completion, error);
    }

}
