package com.hummer._internals.mq;


import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.Error;
import com.hummer._internals.utility.IMRPC;
import com.hummer._internals.proto.Pull;
import com.hummer._internals.utility.RichCompletionArg;
import com.hummer._internals.utility.CompletionUtils;

public class RPCFetchSharedMaxSeqId extends IMRPC<Pull.GetGrpSysMaxSeqIdRequest,
        Pull.GetGrpSysMaxSeqIdRequest.Builder,
        Pull.GetGrpSysMaxSeqIdResponse> {

    private final int queueId;
    private final String topic;
    private final String region;

    private final long groupId;

    private final RichCompletionArg<Long> completion;

    public RPCFetchSharedMaxSeqId(int queueId,
                                  String topic,
                                  long groupId,
                                  String region,
                                  RichCompletionArg<Long> completion) {
        this.queueId = queueId;
        this.topic = topic;
        this.region = region;
        this.groupId = groupId;
        this.completion = completion;
    }

    @Override
    public String getHummerFunction() {
        return "GetGrpSysMaxSeqId";
    }

    @Override
    public String describeHummerResponse(@NonNull Pull.GetGrpSysMaxSeqIdResponse res) {
        return super.describeHummerResponse(res);
    }

    @Override
    public void buildHummerRequest(@NonNull Pull.GetGrpSysMaxSeqIdRequest.Builder builder) throws Throwable {

        builder.setQueueId(queueId).setGroupId(groupId).setTopic(topic).setGroupRegion(region).build().toByteArray();
    }

    @Override
    public void handleHummerSuccess(@NonNull Pull.GetGrpSysMaxSeqIdResponse res) throws Throwable {
        CompletionUtils.dispatchSuccess(completion, res.getMaxSeqId());
    }

    @Override
    public void handleHummerError(@Nullable Pull.GetGrpSysMaxSeqIdResponse res, @NonNull Error error) {
        CompletionUtils.dispatchFailure(completion, error);
    }

}
