package com.hummer._internals.mq;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.Error;
import com.hummer._internals.utility.IMRPC;
import com.hummer._internals.proto.Pull;
import com.hummer._internals.utility.CompletionUtils;
import com.hummer._internals.utility.RichCompletionArg;

public class RPCFetchPrivateMaxSeqId extends IMRPC<Pull.GetMaxSeqIdRequest,
        Pull.GetMaxSeqIdRequest.Builder,
        Pull.GetMaxSeqIdResponse> {

    private final int queueId;

    private final String topic;

    private final RichCompletionArg<Long> completion;

    public RPCFetchPrivateMaxSeqId(int queueId, String topic, RichCompletionArg<Long> completion) {
        this.queueId = queueId;
        this.topic = topic;
        this.completion = completion;
    }

    @Override
    public String getHummerFunction() {
        return "GetMaxSeqId";
    }

    @Override
    public void buildHummerRequest(@NonNull Pull.GetMaxSeqIdRequest.Builder builder) throws Throwable {
        builder.setQueueId(queueId).setTopic(topic).build().toByteArray();
    }

    @Override
    public void handleHummerSuccess(@NonNull Pull.GetMaxSeqIdResponse res) throws Throwable {
        CompletionUtils.dispatchSuccess(completion, res.getMaxSeqId());
    }

    @Override
    public void handleHummerError(@Nullable Pull.GetMaxSeqIdResponse res, @NonNull Error error) {
        CompletionUtils.dispatchFailure(completion, error);
    }

    @Override
    public String describeHummerResponse(@NonNull Pull.GetMaxSeqIdResponse res) {
        return super.describeHummerResponse(res);
    }
}
