package com.hummer._internals.mq;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.Error;
import com.hummer._internals.log.trace.Trace;
import com.hummer._internals.proto.Pull;
import com.hummer._internals.shared.StringChain;
import com.hummer._internals.utility.CompletionUtils;
import com.hummer._internals.utility.IMRPC;
import com.hummer._internals.utility.RichCompletion;

public class RPCCheckMsgIntegrity extends IMRPC<Pull.CheckMsgIntegrityRequest,
        Pull.CheckMsgIntegrityRequest.Builder, Pull.CheckMsgIntegrityResponse> {
    public static final String TAG = "RPCCheckMsgIntegrity";
    private final String topic;
    private final long startSeq;
    private final long endSeq;
    private final int queueId;
    private final RichCompletion completion;
    private final Trace.Flow flow = new Trace.Flow();

    public RPCCheckMsgIntegrity(String topic,
                                long startSeq,
                                long endSeq,
                                int queueId,
                                RichCompletion completion) {
        this.topic = topic;
        this.startSeq = startSeq;
        this.endSeq = endSeq;
        this.queueId = queueId;
        this.completion = completion;
    }

    @Override
    public long getLogId() {
        return flow.logId;
    }

    @Override
    public String getHummerFunction() {
        return "CheckMsgIntegrity";
    }

    @Override
    public String describeHummerResponse(@NonNull Pull.CheckMsgIntegrityResponse res) {
        return new StringChain().acceptNullElements()
                .add("srvCode", res.getCode())
                .add("srvDesc", res.getMsg())
                .toString();
    }

    @Override
    public void buildHummerRequest(@NonNull Pull.CheckMsgIntegrityRequest.Builder builder) {
        builder.setTopic(topic)
                .setStartSeq(startSeq)
                .setEndSeq(endSeq)
                .setQueueId(queueId).build().toByteArray();
    }

    @Override
    public void handleHummerSuccess(@NonNull Pull.CheckMsgIntegrityResponse res) {
        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public void handleHummerError(@Nullable Pull.CheckMsgIntegrityResponse res, @NonNull Error error) {
        CompletionUtils.dispatchFailure(completion, error);
    }

}

