package com.hummer._internals.mq;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.Error;
import com.hummer._internals.log.trace.Trace;
import com.hummer._internals.proto.Pull;
import com.hummer._internals.shared.StringChain;
import com.hummer._internals.utility.CompletionUtils;
import com.hummer._internals.utility.IMRPC;
import com.hummer._internals.utility.RichCompletion;

public class RPCCheckGrpSysMsgIntegrity extends IMRPC<Pull.CheckGrpSysMsgIntegrityRequest,
        Pull.CheckGrpSysMsgIntegrityRequest.Builder, Pull.CheckGrpSysMsgIntegrityResponse> {
    public static final String TAG = "RPCCheckGrpSysMsgIntegrity";
    private final long groupId;
    private final String topic;
    private final long startSeq;
    private final long endSeq;
    private final int queueId;
    private final RichCompletion completion;
    private final Trace.Flow flow = new Trace.Flow();

    public RPCCheckGrpSysMsgIntegrity(long groupId,
                                      String topic,
                                      long startSeq,
                                      long endSeq,
                                      int queueId,
                                      RichCompletion completion) {
        this.groupId    = groupId;
        this.topic      = topic;
        this.startSeq   = startSeq;
        this.endSeq     = endSeq;
        this.queueId    = queueId;
        this.completion = completion;
    }

    @Override
    public long getLogId() {
        return flow.logId;
    }

    @Override
    public String getHummerFunction() {
        return "CheckGrpSysMsgIntegrity";
    }

    @Override
    public String describeHummerResponse(@NonNull Pull.CheckGrpSysMsgIntegrityResponse res) {
        return new StringChain().acceptNullElements()
                .add("srvCode", res.getCode())
                .add("srvDesc", res.getMsg())
                .toString();
    }

    @Override
    public void buildHummerRequest(@NonNull Pull.CheckGrpSysMsgIntegrityRequest.Builder builder) {
        builder.setGroupId(groupId)
                .setTopic(topic)
                .setStartSeq(startSeq)
                .setEndSeq(endSeq)
                .setQueueId(queueId).build().toByteArray();
    }

    @Override
    public void handleHummerSuccess(@NonNull Pull.CheckGrpSysMsgIntegrityResponse res) {
        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public void handleHummerError(@Nullable Pull.CheckGrpSysMsgIntegrityResponse res, @NonNull Error error) {
        CompletionUtils.dispatchFailure(completion, error);
    }
}

