package com.hummer._internals.log.trace;

import android.text.TextUtils;

import com.hummer._internals.utility.LogId;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

@SuppressWarnings("unused")
public final class Trace {

    public static class Flow {
        public final long logId;

        public Flow() {
            this.logId = LogId.generate();
            this.name = String.format(Locale.US, "%-19d", logId);
        }

        public Trace method(String methodName) {
            return new Trace(methodName)
                    .asFlow(name, getIntervalByAdvancingTimestamp());
        }

        private Long getIntervalByAdvancingTimestamp() {
            Long now = System.currentTimeMillis();
            Long interval = null;

            if (timestamps.size() >= 1) {
                Long last = timestamps.get(timestamps.size() - 1);
                interval = now - last;
            }

            timestamps.add(now);
            return interval;
        }

        private final String name;
        private final ArrayList<Long> timestamps = new ArrayList<>();
    }

    public static Trace method(String methodName) {
        return new Trace(methodName);
    }

    public Trace msg(String fmt, Object... args) {
        this.message = String.format(Locale.US, fmt, args);
        return this;
    }

    public Trace msg(Object obj) {
        this.message = (obj == null ? "null" : obj.toString());
        return this;
    }

    public Trace info(String name, Object value) {
        parameters.add(name + ":" + value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();

        if (flowName != null) {
            sb.append(String.format(Locale.US, "[%s]", flowName));
        }

        sb.append(methodName);

        // 过小的时耗没必要进行展示，用户通常只对那些长耗时的操作敏感
        if (flowElapsed != null && flowElapsed >= 10) {
            sb.append("(");
            sb.append(flowElapsed);
            sb.append("ms)");
        }

        if (message != null || parameters.size() > 0) {
            sb.append(" |");
        }

        if (message != null) {
            sb.append(" ");
            sb.append(message);
        }

        if (parameters.size() > 0) {
            sb.append(" {");
            sb.append(TextUtils.join(", ", parameters));
            sb.append("}");
        }

        parameters.clear();
        message = null;

        return sb.toString();
    }

    private Trace(String methodName) {
        this.methodName = methodName;
    }

    private Trace asFlow(String name, Long elapsed) {
        this.flowName = name;
        this.flowElapsed = elapsed;
        return this;
    }

    // [logId]function | message - info
    private final List<String> parameters = new LinkedList<>();
    private String methodName;
    private String message;

    private Long flowElapsed = null;
    private String flowName = null;
}
