package com.hummer._internals.log;

import com.yy.spidercrab.SCLog;

import static android.util.Log.DEBUG;
import static android.util.Log.ERROR;
import static android.util.Log.INFO;
import static android.util.Log.WARN;

public class HummerLogger implements Log.Logger {
    private final String module;

    public HummerLogger(String module) {
        SCLog.addLogger(module);
        this.module = module;
    }

    @Override
    public void log(int lv, String msg) {
        switch (lv) {
            case DEBUG:
                SCLog.d(module, msg);
                break;
            case INFO:
                SCLog.i(module, msg);
                break;
            case WARN:
                SCLog.w(module, msg);
                break;
            case ERROR:
                SCLog.e(module, msg);
                break;
            default:
                break;
        }
    }
}
