package com.hummer._internals;

import android.support.annotation.NonNull;

import com.hummer.HMR;
import com.hummer._internals.mq.MQServiceImpl;
import com.hummer._internals.user.UserService;
import com.hummer._internals.shared.AsciiTable;
import com.hummer._internals.utility.HMRContext;
import com.hummer._internals.utility.PrefStorage;
import com.hummer._internals.utility.ServiceProvider;
import com.hummer._internals.user.UserServiceImpl;
import com.hummer._internals.utility.CompletionUtils;
import com.hummer._internals.utility.RichCompletion;
import com.hummer._internals.channel.Channel;
import com.hummer._internals.mq.MQService;
import com.yy.spidercrab.SCLog;

import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("unused")
public final class SPCoreModuleLoader implements ServiceProvider.ModuleLoader {

    static class LoggerService implements ServiceProvider.Service {
        @Override
        public void initService() {

        }

        @Override
        public void deInitService() {

        }

        @Override
        public Class[] staticDependencies() {
            return null;
        }

        @Override
        public Class[] inherentDynamicDependencies() {
            return new Class[]{Channel.class};
        }

        @Override
        public Class[] plantingDynamicDependencies() {
            return null;
        }

        @Override
        public void openService(@NonNull RichCompletion completion) {
            SCLog.activeLoggerReport(HMRContext.getAppId());
            SCLog.addUser(HMR.getMe() + "");
            CompletionUtils.dispatchSuccess(completion);
        }

        @Override
        public void closeService() {
            SCLog.removeUser(HMR.getMe() + "");
            SCLog.disableLoggerReport();
        }
    }

    @Override
    public void initModule() {
        showInitMessage();
    }

    @Override
    public void deInitModule() {
        showDeInitMessage();
    }

    @Override
    public Map<Class, ServiceProvider.Service> getServices() {
        return new HashMap<Class, ServiceProvider.Service>() {{
            put(PrefStorage.class, PrefStorage.storage());
            put(UserService.class, new UserServiceImpl());
            put(MQService.class, new MQServiceImpl());
            put(LoggerService.class, new LoggerService());
        }};
    }

    private static void showInitMessage() {
        AsciiTable.log(40, "Welcome to Hummer", new String[][]{
                {"version", HMR.getVersion()},
                {"appId", String.valueOf(HMRContext.appId)},
        });
    }

    private static void showDeInitMessage() {
        AsciiTable.log(40, "Welcome to Hummer Next Time", new String[][]{
                {"version", HMR.getVersion()},
                {"appId", String.valueOf(HMRContext.appId)},
        });
    }
}
