package com.hummer;

import java.util.HashSet;
import java.util.Set;

/**
 * 错误枚举
 *
 * @author hummer组
 */
public enum ErrorEnum {

    /**
     * kOk
     */
    OK(0, "成功"),

    /**
     * kUnknownError
     */
    UNKNOWN_ERROR(1, "未知错误"),

    /**
     * KLoginKickOut = 100; // 登录互踢
     */
    LOGIN_KICK_OUT(100, "登录互踢"),


    /* 客户端错误 */

    /**
     * kUninitializedException = 1001;
     */
    UNINITIALIZED_EXCEPTION(1001, "没有初始化"),

    /**
     * kDBError
     */
    DB_ERROR(1003, "访问本地数据库错误"),

    /**
     * kOperationTimeout
     */
    OPERATION_TIMEOUT(1005, "操作超时"),

    /**
     * kConnectionException
     */
    CONNECTION_EXCEPTION(1007, "连接异常"),

    /**
     * kUnauthorizedException = 1009; // 没有登录
     */
    UNAUTHORIZED_EXCEPTION(1009, "鉴权失败"),

    /**
     * kBadUserError = 1011;
     * 如果业务没有正确处理用户上下文切换，例如业务已经注销了用户，但是没有调用Hummer.close，则会产生该错误
     */
    BAD_USER_ERROR(1011, "未正确切换用户上下文"),


    /* 通用错误 */

    /**
     * kInvalidParameter
     */
    INVALID_PARAMETER(2001, "无效参数"),

    /**
     * kInvalidTokenException
     */
    INVALID_TOKEN_EXCEPTION(2002, "Token校验错误"),

    /**
     * kExpiredTokenException
     */
    EXPIRED_TOKEN_EXCEPTION(2003, "Token过期"),

    /**
     * kResourceNotFoundException
     */
    RESOURCE_NOT_FOUND_EXCEPTION(2004, "资源不存在"),

    /**
     * kMsgSizeLimitExceeded
     */
    MSG_SIZE_LIMIT_EXCEEDED(2007, "消息长度超上限"),

    /**
     * kAppidUnavailable = 2018;   // appid不可用
     */
    APP_ID_UNAVAILABLE(2018, "无效的appId"),

    /**
     * kPermissionDeny = 3000; //权限验证失败
     */
    PERMISSION_DENY(3000, "权限验证失败"),

    /**
     * kContentCensorshipDeny = 3007;   //内容审查失败
     */
    CONTENT_CENSORSHIP_DENY(3007, "内容审查失败"),

    /**
     * kUserChatDisabled = 3009;  //用户被禁言
     */
    USER_CHAT_DISABLED(3009, "用户被禁言"),

    /**
     * kInternalServerError = 4000; //服务器错误
     */
    INTERNAL_SERVER_ERROR(4000, "服务器错误"),

    /**
     * kOperationTooOften = 4003; //操作过于频繁
     */
    OPERATION_TOO_OFTEN(4003, "操作过于频繁"),


    /* RoomService错误码 */

    /**
     * kUserNotInRoom = 5101；//用户不在频道
     */
    USER_NOT_IN_ROOM(5101, "用户不在频道"),

    /**
     * kRoomUserLimitExceeded = 5102；//频道人数超过上限
     */
    ROOM_USER_LIMIT_EXCEEDED(5102, "频道人数超过上限"),

    /**
     * kRoomUserInfoItemsOverFlow = 5103; //频道用户信息个数超过上限
     */
    ROOM_USER_INFO_ITEMS_OVER_FLOW(5103, "频道用户信息个数超过上限"),

    /**
     * kRoomUserInfoSizeOverFlow = 5104; //频道用户信息长度超过上限
     */
    ROOM_USER_INFO_SIZE_OVER_FLOW(5104, "频道用户信息长度超过上限"),

    /**
     * kRoomInfoItemsOverFlow = 5105; //频道信息个数超过上限
     */
    ROOM_INFO_ITEMS_OVER_FLOW(5105, "频道信息个数超过上限"),

    /**
     * kRoomInfoSizeOverFlow = 5106; //频道信息长度超过上限
     */
    ROOM_INFO_SIZE_OVER_FLOW(5106, "频道信息长度超过上限"),

    /**
     * kRoomPropsNotExist = 5108；//频道属性不存在
     */
    ROOM_PROPS_NOT_EXIST(5108, "频道属性不存在"),

    /**
     * kRoomCountLimitExceeded = 5109；//请求频道数量超过上线
     */
    ROOM_COUNT_LIMIT_EXCEEDED(5109, "请求频道数量超过上线");

    //业务自定义错误(大于等于10000)
    //kCustomErrorStart = 10000;


    private int code;

    private String desc;

    ErrorEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static Set<Integer> codeSet = new HashSet<>();

    static {
        for (ErrorEnum errorEnum : ErrorEnum.values()) {
            codeSet.add(errorEnum.getCode());
        }
    }

    /**
     * 判读errorCode是否在枚举值之内
     *
     * <br> 业务自定义返回码，直接返回true
     *
     * @param errorCode 错误码
     * @return true: 包含；false: 不包含
     */
    public static boolean contains(int errorCode) {
        if (errorCode >= CUSTOM_ERROR_START) {
            return true;
        }
        return codeSet.contains(errorCode);
    }

    /**
     * 业务自定义错误码从 10000 开始
     */
    private static final int CUSTOM_ERROR_START = 10000;
}
