package com.hummer;

import com.hummer._internals.log.Log;
import com.hummer._internals.log.trace.Trace;

import java.util.Locale;

/**
 * 该Error类型是Hummer中用于表示通用错误的类型，常见于消息收发等需要网络通讯的请求中.
 */
public final class Error {

    /**
     * code属性主要用于进行机器判别、日志快速定位等作用
     */
    public final int code;

    /**
     * reason属性通过人可读的文本形式对mCode进行了描述
     */
    public final String desc;

    /**
     * 构造Error实例
     *
     * @param code 处理结果的代码
     * @param desc 处理结果的文本描述
     */
    public Error(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Error(ErrorEnum errorEnum) {
        this(errorEnum.getCode(), errorEnum.getDesc());
    }

    public Error(ErrorEnum errorEnum, String desc) {
        this(errorEnum.getCode(), desc);
    }

    public static Error ofError(int code, String desc) {
        Error error;
        if (ErrorEnum.contains(code)) {
            error = new Error(code, desc);
        } else {
            Log.w("Error", Trace.method("ofError")
                    .msg("error code is undefined")
                    .info("code", code));
            error = new Error(ErrorEnum.UNKNOWN_ERROR, desc);
        }

        return error;
    }

    @Override
    public String toString() {
        return String.format(Locale.US, "Error{%d, %s}", code, desc);
    }
}
