/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.widget.viewpager;

import android.content.Context;
import android.database.DataSetObserver;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.appcompat.app.AppCompatActivity;
import androidx.lifecycle.LifecycleObserver;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.edu24ol.newclass.widget.viewpager.LoopPagerAdapter;
import com.edu24ol.newclass.widget.viewpager.MyLifeCycleObserver;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.yy.android.educommon.log.YLog;
import java.lang.ref.WeakReference;

public class LoopViewPager
extends ViewPager {
    private static final String TAG = "LoopViewPager";
    private static final boolean DEBUG = false;
    private ViewPager.OnPageChangeListener mOuterPageChangeListener;
    private LoopPagerAdapter mAdapter;
    private AppCompatActivity mActivity;
    private MyLifeCycleObserver mMyLifeCycleObserver;
    private ViewPager.OnPageChangeListener onPageChangeListener = new ViewPager.OnPageChangeListener(){
        private float mPreviousOffset = -1.0f;
        private float mPreviousPosition = -1.0f;

        public void onPageSelected(int position) {
            int realPosition = LoopViewPager.this.mAdapter.toRealPosition(position);
            LoopViewPager.this.mCurrentPageIndex = realPosition;
            if (this.mPreviousPosition != (float)realPosition) {
                this.mPreviousPosition = realPosition;
                if (LoopViewPager.this.mOuterPageChangeListener != null) {
                    LoopViewPager.this.mOuterPageChangeListener.onPageSelected(realPosition);
                }
            }
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            int realPosition = position;
            this.mPreviousOffset = positionOffset;
            if (LoopViewPager.this.mOuterPageChangeListener != null) {
                if (realPosition != LoopViewPager.this.mAdapter.getRealCount() - 1) {
                    LoopViewPager.this.mOuterPageChangeListener.onPageScrolled(realPosition, positionOffset, positionOffsetPixels);
                } else if ((double)positionOffset > 0.5) {
                    LoopViewPager.this.mOuterPageChangeListener.onPageScrolled(0, 0.0f, 0);
                } else {
                    LoopViewPager.this.mOuterPageChangeListener.onPageScrolled(realPosition, 0.0f, 0);
                }
            }
        }

        public void onPageScrollStateChanged(int state) {
            if (LoopViewPager.this.mAdapter != null) {
                int position = LoopViewPager.super.getCurrentItem();
                int realPosition = LoopViewPager.this.mAdapter.toRealPosition(position);
                if (state == 0 && (position == 0 || position == LoopViewPager.this.mAdapter.getCount() - 1)) {
                    LoopViewPager.this.setCurrentItem(realPosition, false);
                }
            }
            switch (state) {
                case 0: {
                    if (!LoopViewPager.this.mDraged) break;
                    YLog.debug((Object)this, (String)"SCROLL_STATE_IDLE send msg");
                    LoopViewPager.this.mHandler.removeMessages(1);
                    LoopViewPager.this.mHandler.sendEmptyMessageDelayed(1, LoopViewPager.this.mChangeDelay);
                    LoopViewPager.this.mDraged = false;
                    break;
                }
                case 2: {
                    if (!LoopViewPager.this.mDraged) break;
                    YLog.debug((Object)this, (String)"SCROLL_STATE_SETTLING remove msg");
                    LoopViewPager.this.mHandler.removeMessages(1);
                    break;
                }
                case 1: {
                    LoopViewPager.this.mDraged = true;
                    YLog.debug((Object)this, (String)"SCROLL_STATE_DRAGGING");
                    break;
                }
            }
            if (LoopViewPager.this.mOuterPageChangeListener != null) {
                LoopViewPager.this.mOuterPageChangeListener.onPageScrollStateChanged(state);
            }
        }
    };
    private static final int MSG_CHANGE = 1;
    private int mChangeDelay = 5000;
    private int mCurrentPageIndex = 0;
    private int mMaxPages = 0;
    private boolean mDraged = false;
    private UIHandler mHandler;
    private DataSetObserver dataSetObserver = new DataSetObserver(){

        public void onChanged() {
            super.onChanged();
            LoopViewPager.this.onAdapterChanged();
        }

        public void onInvalidated() {
            super.onInvalidated();
        }
    };

    public static int toRealPosition(int position, int count) {
        position = --position < 0 ? (position += count) : (position %= count);
        return position;
    }

    public void setAdapter(PagerAdapter adapter) {
        PagerAdapter adapterTmp = this.getAdapter();
        if (adapterTmp != null) {
            adapterTmp.unregisterDataSetObserver(this.dataSetObserver);
        }
        if (!(adapter instanceof LoopPagerAdapter)) {
            throw new IllegalArgumentException("the adapter must be LoopPagerAdapter");
        }
        this.mAdapter = (LoopPagerAdapter)adapter;
        super.setAdapter((PagerAdapter)this.mAdapter);
        this.setCurrentItem(0, false);
        if (this.mAdapter != null) {
            adapter.registerDataSetObserver(this.dataSetObserver);
        }
        this.onAdapterChanged();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        SensorsDataAPI.sharedInstance().ignoreView((View)this);
    }

    public PagerAdapter getAdapter() {
        return this.mAdapter;
    }

    public int getCurrentItem() {
        return this.mAdapter != null ? this.mAdapter.toRealPosition(super.getCurrentItem()) : 0;
    }

    public int getSuperCurrentItem() {
        return this.mAdapter != null ? super.getCurrentItem() : 0;
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        int realItem = this.mAdapter.toInnerPosition(item);
        super.setCurrentItem(realItem, smoothScroll);
    }

    public void setCurrentItem(int item) {
        if (this.getCurrentItem() != item) {
            this.setCurrentItem(item, true);
        }
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mOuterPageChangeListener = listener;
    }

    public LoopViewPager(Context context) {
        this(context, null);
    }

    public LoopViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (context != null && context instanceof AppCompatActivity) {
            this.mActivity = (AppCompatActivity)context;
        }
        this.init();
    }

    private void init() {
        this.mHandler = new UIHandler(this);
        super.setOnPageChangeListener(this.onPageChangeListener);
    }

    protected void onPageScrolled(int position, float offset, int offsetPixels) {
        int realPosition = position;
        if (this.mAdapter != null) {
            realPosition = this.mAdapter.toRealPosition(position);
        }
        super.onPageScrolled(realPosition, offset, offsetPixels);
    }

    public void setChangeDelay(int changeDelay) {
        this.mChangeDelay = changeDelay;
    }

    private void onAdapterChanged() {
        this.mHandler.removeMessages(1);
        if (this.mAdapter != null && this.mAdapter.getCount() > 0) {
            this.mCurrentPageIndex = 0;
            this.mMaxPages = this.mAdapter.getRealCount();
            if (this.mMaxPages > 1) {
                this.mHandler.removeMessages(1);
                this.mHandler.sendEmptyMessageDelayed(1, this.mChangeDelay);
            }
        } else {
            this.mCurrentPageIndex = 0;
            this.mMaxPages = 0;
        }
    }

    public void startRoll(boolean isStartRoll) {
        if (this.mAdapter != null && this.mAdapter.getCount() > 0) {
            this.mMaxPages = this.mAdapter.getRealCount();
            if (this.mMaxPages > 1 && this.mHandler != null) {
                this.mHandler.removeMessages(1);
                if (isStartRoll) {
                    this.mHandler.sendEmptyMessageDelayed(1, this.mChangeDelay);
                }
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        YLog.debug((Object)((Object)this), (String)"onDetachedFromWindow");
        this.mHandler.removeMessages(1);
        if (this.mActivity != null && this.mMyLifeCycleObserver != null) {
            this.mActivity.getLifecycle().removeObserver((LifecycleObserver)this.mMyLifeCycleObserver);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        YLog.debug((Object)((Object)this), (String)"onAttachedToWindow");
        this.mHandler.removeMessages(1);
        this.mHandler.sendEmptyMessageDelayed(1, this.mChangeDelay);
        if (this.mActivity != null) {
            this.mMyLifeCycleObserver = new MyLifeCycleObserver(){

                @Override
                public void onActivityResume() {
                    LoopViewPager.this.startRoll(true);
                }

                @Override
                public void onActivityPause() {
                    LoopViewPager.this.startRoll(false);
                }
            };
            this.mActivity.getLifecycle().addObserver((LifecycleObserver)this.mMyLifeCycleObserver);
        }
    }

    public boolean onInterceptHoverEvent(MotionEvent event) {
        try {
            return super.onInterceptHoverEvent(event);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static class UIHandler
    extends Handler {
        private WeakReference<LoopViewPager> mReference;

        public UIHandler(LoopViewPager loopViewPager) {
            this.mReference = new WeakReference<LoopViewPager>(loopViewPager);
        }

        public void handleMessage(Message msg) {
            LoopViewPager loopViewPager = (LoopViewPager)((Object)this.mReference.get());
            if (loopViewPager == null) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    if (loopViewPager.mMaxPages <= 0 || loopViewPager.mCurrentPageIndex >= loopViewPager.mMaxPages) break;
                    try {
                        loopViewPager.setCurrentItem(loopViewPager.mCurrentPageIndex);
                    }
                    catch (Exception e) {
                        YLog.error((Object)((Object)this), (Throwable)e);
                    }
                    loopViewPager.mCurrentPageIndex++;
                    if (loopViewPager.mCurrentPageIndex < 0 || loopViewPager.mCurrentPageIndex >= loopViewPager.mMaxPages) {
                        loopViewPager.mCurrentPageIndex = 0;
                    }
                    this.removeMessages(1);
                    this.sendEmptyMessageDelayed(1, loopViewPager.mChangeDelay);
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }
}

