/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.widget.viewpager;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.viewpager.widget.PagerAdapter;
import java.util.ArrayList;
import java.util.List;

public abstract class LoopPagerAdapter<T>
extends PagerAdapter {
    private List<T> redirectItems = new ArrayList<T>();
    private Context mContext;
    private View.OnClickListener mClickListener;

    public LoopPagerAdapter(Context context, View.OnClickListener clickListener) {
        this.mContext = context;
        this.mClickListener = clickListener;
    }

    public LoopPagerAdapter(Context context, List<T> itemList, View.OnClickListener clickListener) {
        this.mContext = context;
        this.redirectItems.addAll(itemList);
        this.mClickListener = clickListener;
    }

    public LoopPagerAdapter() {
    }

    public int toRealPosition(int position) {
        int realCount = this.getRealCount();
        if (realCount == 0) {
            return 0;
        }
        int realPosition = (position - 1) % realCount;
        if (realPosition < 0) {
            realPosition += realCount;
        }
        return realPosition;
    }

    public void addData(List<T> redirectItems) {
        this.redirectItems.addAll(redirectItems);
    }

    public void setData(List<T> redirectItems) {
        this.redirectItems.clear();
        this.addData(redirectItems);
    }

    public int toInnerPosition(int realPosition) {
        int position = realPosition + 1;
        return position;
    }

    private int getRealFirstPosition() {
        return 1;
    }

    private int getRealLastPosition() {
        return this.getRealFirstPosition() + this.getRealCount() - 1;
    }

    public int getCount() {
        return this.redirectItems == null ? 0 : this.redirectItems.size();
    }

    public int getRealCount() {
        return this.getCount() - 2;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        T t = this.redirectItems.get(position);
        return this.onInstantiateItem(container, position, t);
    }

    public T getDataFromPosition(int position) {
        if (this.redirectItems != null && position < this.redirectItems.size()) {
            return this.redirectItems.get(position);
        }
        return null;
    }

    protected abstract Object onInstantiateItem(ViewGroup var1, int var2, T var3);

    public void destroyItem(ViewGroup container, int position, Object object) {
        View view = (View)object;
        if (view != null && view.getParent() != null) {
            container.removeView(view);
        }
    }

    public boolean isViewFromObject(View view, Object o) {
        return view == o;
    }

    public int getItemPosition(Object object) {
        return -2;
    }
}

