/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.widget.viewpager;

import android.content.Context;
import android.database.DataSetObserver;
import android.util.AttributeSet;
import android.view.MotionEvent;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.edu24ol.newclass.widget.viewpager.LoopPagerAdapter;
import com.yy.android.educommon.log.YLog;

public class DragLoopViewPager
extends ViewPager {
    private ViewPager.OnPageChangeListener mOuterPageChangeListener;
    private LoopPagerAdapter mAdapter;
    private ViewPager.OnPageChangeListener onPageChangeListener = new ViewPager.OnPageChangeListener(){
        private float mPreviousOffset = -1.0f;
        private float mPreviousPosition = -1.0f;

        public void onPageSelected(int position) {
            int realPosition = DragLoopViewPager.this.mAdapter.toRealPosition(position);
            DragLoopViewPager.this.mCurrentPageIndex = realPosition;
            if (this.mPreviousPosition != (float)realPosition) {
                this.mPreviousPosition = realPosition;
                if (DragLoopViewPager.this.mOuterPageChangeListener != null) {
                    DragLoopViewPager.this.mOuterPageChangeListener.onPageSelected(realPosition);
                }
            }
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            int realPosition = position;
            if (DragLoopViewPager.this.mAdapter != null) {
                realPosition = DragLoopViewPager.this.mAdapter.toRealPosition(position);
            }
            this.mPreviousOffset = positionOffset;
            if (DragLoopViewPager.this.mOuterPageChangeListener != null) {
                if (realPosition != DragLoopViewPager.this.mAdapter.getRealCount() - 1) {
                    DragLoopViewPager.this.mOuterPageChangeListener.onPageScrolled(realPosition, positionOffset, positionOffsetPixels);
                } else if ((double)positionOffset > 0.5) {
                    DragLoopViewPager.this.mOuterPageChangeListener.onPageScrolled(0, 0.0f, 0);
                } else {
                    DragLoopViewPager.this.mOuterPageChangeListener.onPageScrolled(realPosition, 0.0f, 0);
                }
            }
        }

        public void onPageScrollStateChanged(int state) {
            if (DragLoopViewPager.this.mAdapter != null) {
                int position = DragLoopViewPager.super.getCurrentItem();
                int realPosition = DragLoopViewPager.this.mAdapter.toRealPosition(position);
                if (state == 0 && (position == 0 || position == DragLoopViewPager.this.mAdapter.getCount() - 1)) {
                    DragLoopViewPager.this.setCurrentItem(realPosition, false);
                }
            }
            switch (state) {
                case 0: {
                    if (!DragLoopViewPager.this.mDraged) break;
                    YLog.debug((Object)this, (String)"SCROLL_STATE_IDLE send msg");
                    DragLoopViewPager.this.mDraged = false;
                    break;
                }
                case 2: {
                    if (!DragLoopViewPager.this.mDraged) break;
                    YLog.debug((Object)this, (String)"SCROLL_STATE_SETTLING remove msg");
                    break;
                }
                case 1: {
                    DragLoopViewPager.this.mDraged = true;
                    YLog.debug((Object)this, (String)"SCROLL_STATE_DRAGGING");
                    break;
                }
            }
            if (DragLoopViewPager.this.mOuterPageChangeListener != null) {
                DragLoopViewPager.this.mOuterPageChangeListener.onPageScrollStateChanged(state);
            }
        }
    };
    private int mCurrentPageIndex = 0;
    private int mMaxPages = 0;
    private boolean mDraged = false;
    private DataSetObserver dataSetObserver = new DataSetObserver(){

        public void onChanged() {
            super.onChanged();
            DragLoopViewPager.this.onAdapterChanged();
        }

        public void onInvalidated() {
            super.onInvalidated();
        }
    };

    public static int toRealPosition(int position, int count) {
        position = --position < 0 ? (position += count) : (position %= count);
        return position;
    }

    public void setAdapter(PagerAdapter adapter) {
        PagerAdapter adapterTmp = this.getAdapter();
        if (adapterTmp != null) {
            adapterTmp.unregisterDataSetObserver(this.dataSetObserver);
        }
        if (!(adapter instanceof LoopPagerAdapter)) {
            throw new IllegalArgumentException("the adapter must be LoopPagerAdapter");
        }
        this.mAdapter = (LoopPagerAdapter)adapter;
        super.setAdapter((PagerAdapter)this.mAdapter);
        this.setCurrentItem(0, false);
        if (this.mAdapter != null) {
            adapter.registerDataSetObserver(this.dataSetObserver);
        }
        this.onAdapterChanged();
    }

    public PagerAdapter getAdapter() {
        return this.mAdapter;
    }

    public int getCurrentItem() {
        return this.mAdapter != null ? this.mAdapter.toRealPosition(super.getCurrentItem()) : 0;
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        int realItem = this.mAdapter.toInnerPosition(item);
        super.setCurrentItem(realItem, smoothScroll);
    }

    public void setCurrentItem(int item) {
        if (this.getCurrentItem() != item) {
            this.setCurrentItem(item, true);
        }
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mOuterPageChangeListener = listener;
    }

    public DragLoopViewPager(Context context) {
        this(context, null);
    }

    public DragLoopViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        super.setOnPageChangeListener(this.onPageChangeListener);
    }

    private void onAdapterChanged() {
        if (this.mAdapter != null && this.mAdapter.getCount() > 0) {
            this.mCurrentPageIndex = 0;
            this.mMaxPages = this.mAdapter.getRealCount();
        } else {
            this.mCurrentPageIndex = 0;
            this.mMaxPages = 0;
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        YLog.debug((Object)((Object)this), (String)"onDetachedFromWindow");
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        YLog.debug((Object)((Object)this), (String)"onAttachedToWindow");
    }

    public boolean onInterceptHoverEvent(MotionEvent event) {
        try {
            return super.onInterceptHoverEvent(event);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

