/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.video;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import base.BasePlayListItem;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.widgets.AbstractBaseRecycleViewAdapter;

public class VideosPlayListAdapter<T extends BasePlayListItem>
extends AbstractBaseRecycleViewAdapter<T> {
    public int mCurrentPlayPosition;
    public OnItemClickListener mOnItemClickListener;

    public void updatePlayPosition(int currentPlayPosition) {
        this.mCurrentPlayPosition = currentPlayPosition;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public VideosPlayListAdapter(Context context) {
        super(context);
    }

    private View initItemLayoutInflater(ViewGroup parent, int resourse) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(resourse, parent, false);
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        return new VideosPlayItemViewHolder(this.initItemLayoutInflater(viewGroup, R.layout.pc_item_horizontal_videos_list));
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, final int position) {
        if (viewHolder instanceof VideosPlayItemViewHolder) {
            VideosPlayItemViewHolder itemViewHolder = (VideosPlayItemViewHolder)viewHolder;
            BasePlayListItem playListItem = (BasePlayListItem)this.getItem(position);
            if (!TextUtils.isEmpty((CharSequence)playListItem.getDownloadedFilePath())) {
                itemViewHolder.mAlreadyDownloadVideoImg.setVisibility(0);
            } else {
                itemViewHolder.mAlreadyDownloadVideoImg.setVisibility(8);
            }
            itemViewHolder.mVideoTitleView.setText((CharSequence)playListItem.getName());
            if (this.mCurrentPlayPosition == position) {
                itemViewHolder.mVideoTitleView.setTextColor(this.mContext.getResources().getColor(R.color.new_tab_selected_text_color));
            } else {
                itemViewHolder.mVideoTitleView.setTextColor(Color.parseColor((String)"#ffffff"));
            }
            itemViewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (VideosPlayListAdapter.this.mOnItemClickListener != null) {
                        VideosPlayListAdapter.this.mOnItemClickListener.onItemClick(position);
                    }
                }
            });
        }
    }

    private static class VideosPlayItemViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView mAlreadyDownloadVideoImg;
        private TextView mVideoTitleView;

        public VideosPlayItemViewHolder(View itemView) {
            super(itemView);
            this.mAlreadyDownloadVideoImg = (ImageView)itemView.findViewById(R.id.item_horizontal_videos_list_already_down_icon);
            this.mVideoTitleView = (TextView)itemView.findViewById(R.id.item_horizontal_videos_list_name);
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1);
    }
}

