/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.video;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.CountDownTimer;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import base.BasePlayListItem;
import base.IBaseVideoView;
import base.IVideoPlayer;
import base.PlayListController;
import com.bumptech.glide.Glide;
import com.edu24ol.newclass.video.VideosPlayListAdapter;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.stat.StatAgent;
import com.hqwx.android.platform.utils.DisplayUtils;
import com.hqwx.android.platform.utils.ToastUtil;
import com.hqwx.android.playercontroller.BaseVideoPlaySpeedView;
import com.hqwx.android.playercontroller.CommonVideoController;
import com.hqwx.android.playercontroller.CourseVideoDefinitionView;
import com.hqwx.android.playercontroller.CourseVideoPlaySpeedView;
import com.hqwx.android.playercontroller.R;
import com.hqwx.android.playercontroller.util.PrefUtils;
import com.hqwx.android.service.ServiceFactory;
import com.yy.android.educommon.utils.NetworkUtil;
import io.vov.vitamio.utils.AnimationUtils;
import io.vov.vitamio.utils.StringUtils;
import java.util.ArrayList;

public class VideoMediaController
extends CommonVideoController
implements View.OnClickListener {
    private static final String TAG = "MediaController";
    private Context mContext;
    private IBaseVideoView mCommonVideoView;
    private LinearLayout mTopLayout;
    private RelativeLayout mBottomLayout;
    private RelativeLayout mLockedBottomLayout;
    private RelativeLayout mContentLayout;
    private RelativeLayout mLockedRightLayout;
    private RelativeLayout mRightLayout;
    private View mBottomHorizontalView;
    private View mBottomVerticalView;
    private View mBottomLockedView;
    private SeekBar mHorizontalSeekBar;
    private SeekBar mOrientalSeekBar;
    private View mFullScreenView;
    private View mTopCastView;
    private View mTopBackView;
    private TextView mTopTitleView;
    private TextView mHorizontalCurrentTimeView;
    private TextView mHorizontalTotalTimeView;
    private TextView mVerticalCurrentTimeView;
    private TextView mVerticalTotalTimeView;
    private ImageView mVerticalReplayView;
    private ImageView mHorizontalReplayView;
    private TextView mCurrentPlaySpeedView;
    private View mSpeedControlRootView;
    private TextView mCurrentPlayDefinitionView;
    private View mPlayDefinitionRootView;
    private View mVideosListRootView;
    private View mVideosListShowView;
    private VideosPlayListAdapter mVideoPlayListAdapter;
    private ImageView mHorizontalStatusImg;
    private ImageView mVerticalStatusImg;
    private ImageView mHorizontalNextLessonImg;
    private View mContentPlayCompletionRootView;
    private View mContentLoadVideoErrorView;
    private View mContentMobileNetNoticeRootView;
    private CourseVideoDefinitionView mCourseVideoDefinitionView;
    private ImageView mQrCodeIv;
    private CheckBox mLockVideoCbx;
    private SeekBar mLockedSeekBar;
    private Button mSeeMoreBtn;
    private View mPortraitPipView;
    private View mHorizontalPipView;
    private long mStartPlayTime;
    private View mContentCompletionHomeworkView;
    private int mSecondCategory;
    private PlayListController<BasePlayListItem> mPlayListController;
    private CountDownTimer mDownTimer;
    private boolean isTimerFinished;
    private boolean mShowQrCodeIv;
    private String mQrCodeImageUrl;
    private static final long QRCODE_SHOW_DURATION_IN_MILLIS = 20001L;
    private static final int QRCODE_SHOW_POSITION = 25;
    private boolean isShowSeeMoreButton = false;
    public OnEventListener mOnEventListener;
    private View.OnClickListener mSeeMoreClickListener;
    private Animation mRightInAnimation;
    private Animation mRightOutAnimation;
    private ObjectAnimator mBottomInAnimator;
    private ObjectAnimator mBottomOutAnimator;
    private Animation.AnimationListener mRightOutAnimationListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            VideoMediaController.this.mSeeMoreBtn.setVisibility(8);
        }

        public void onAnimationRepeat(Animation animation) {
        }
    };
    private OnCastViewClickListener mOnCastViewClickListener;

    public void setPlayList(ArrayList<BasePlayListItem> playList) {
        this.mPlayListController.setPlayList(playList);
        if (this.mVideoPlayListAdapter != null) {
            this.mVideoPlayListAdapter.setData(playList);
            this.mVideoPlayListAdapter.notifyDataSetChanged();
        }
    }

    public IVideoPlayer getVideoPlayer() {
        if (this.mCommonVideoView != null) {
            return this.mCommonVideoView.getMediaPlayer();
        }
        return null;
    }

    public void setStartPosition(long startPosition) {
        if (this.mCommonVideoView != null) {
            this.mCommonVideoView.setPosition(startPosition);
        }
    }

    public long getCurrentPosition() {
        if (this.mCommonVideoView != null) {
            return this.mCommonVideoView.getCurrentPosition();
        }
        return 0L;
    }

    public long getDuration() {
        if (this.mCommonVideoView != null) {
            return this.mCommonVideoView.getDuration();
        }
        return 0L;
    }

    public long getStartPlayTime() {
        return this.mStartPlayTime;
    }

    public void setPlayVideoPath(boolean isShowTipsLoading) {
        BasePlayListItem playListItem = this.mPlayListController.getCurrentPlayItem();
        if (playListItem != null) {
            String videoUrl = playListItem.getPlayVideoUrl(PrefUtils.getVideoDefinition((Context)this.mContext));
            if (this.mContentLayout != null) {
                this.setContentViewVisible(false);
                if (NetworkUtil.isMobileNetwork((Context)this.getContext()) && this.getVideoMode(videoUrl) != 1 && !ServiceFactory.getAppService().isAllowMobileNetPlayVideo(this.mContext)) {
                    this.showLoadingMobileNetNotice();
                    return;
                }
            }
            this.setReplayViewVisible(false);
            this.hideSeeMoreButton();
            this.mTopTitleView.setText((CharSequence)playListItem.getName());
            this.mStartPlayTime = System.currentTimeMillis();
            this.setCurrentStartPosition();
            this.resetMediaController();
            this.mCommonVideoView.setVideoPath(videoUrl);
            int videoDefinition = playListItem.getVideoDefinitionByUrl(videoUrl);
            if (videoDefinition > 0) {
                this.showDefinitionView();
                this.setCurrentPlayDefinitionViewText(videoDefinition);
            } else {
                this.hideDefinitionView();
            }
            this.initMediaPlaySpeed();
            if (isShowTipsLoading) {
                this.showFirstLoading();
            }
        }
    }

    public boolean isPlaying() {
        return this.mCommonVideoView != null && this.mCommonVideoView.isPlaying();
    }

    public VideoMediaController(Context context) {
        this(context, null);
    }

    public VideoMediaController(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        this.mPlayListController = new PlayListController();
        this.mTopLayout = (LinearLayout)this.findViewById(R.id.common_controller_top_layout);
        this.mBottomLayout = (RelativeLayout)this.findViewById(R.id.common_controller_bottom_layout);
        this.mLockedBottomLayout = (RelativeLayout)this.findViewById(R.id.common_controller_locked_bottom_layout);
        this.mContentLayout = (RelativeLayout)this.findViewById(R.id.common_controller_content_layout);
        this.mLockedRightLayout = (RelativeLayout)this.findViewById(R.id.common_controller_locked_right_layout);
        this.addLockView();
        this.mRightLayout = (RelativeLayout)this.findViewById(R.id.common_controller_right_layout);
        this.mQrCodeIv = (ImageView)this.findViewById(R.id.common_iv_qrcode);
        this.mCommonVideoView = super.getCommonVideoView();
        this.mSeeMoreBtn = (Button)this.findViewById(R.id.btn_see_more);
        this.mSeeMoreBtn.setOnClickListener((View.OnClickListener)this);
        this.initView();
        this.initMediaPlaySpeed();
        this.initPlayDefinition();
        this.initAnimation();
    }

    private void initView() {
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.pc_course_video_top_layout, (ViewGroup)this.mTopLayout, true);
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.discover_common_video_bottom_horizontal_layout, (ViewGroup)this.mBottomLayout, true);
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.pc_course_video_bottom_vertial_layout, (ViewGroup)this.mBottomLayout, true);
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.pc_locked_seekbar_layout, (ViewGroup)this.mLockedBottomLayout, true);
        this.mBottomLockedView = this.mLockedBottomLayout.getChildAt(0);
        this.mLockedSeekBar = (SeekBar)this.mLockedBottomLayout.findViewById(R.id.lock_sbar_controller);
        this.mLockedSeekBar.setPadding(0, 0, 0, 0);
        this.mLockedSeekBar.setOnSeekBarChangeListener(this.mSeekBarChangeListener);
        if (this.mBottomLayout.getChildCount() == 2) {
            this.mBottomHorizontalView = this.mBottomLayout.getChildAt(0);
            this.mBottomVerticalView = this.mBottomLayout.getChildAt(1);
        }
        this.mTopCastView = this.findViewById(R.id.icon_portrait_controller_cast);
        this.mTopBackView = this.findViewById(R.id.icon_video_controller_back_img);
        this.mTopTitleView = (TextView)this.findViewById(R.id.icon_video_controller_title_view);
        this.mFullScreenView = this.findViewById(R.id.btn_toggle_screen);
        this.mHorizontalSeekBar = (SeekBar)this.findViewById(R.id.sbar_controller);
        this.mHorizontalSeekBar.setPadding(0, 0, 0, 0);
        this.mHorizontalSeekBar.setOnSeekBarChangeListener(this.mSeekBarChangeListener);
        this.mOrientalSeekBar = (SeekBar)this.findViewById(R.id.sbar_portrait_controller);
        this.mOrientalSeekBar.setPadding(0, 0, 0, 0);
        this.mOrientalSeekBar.setOnSeekBarChangeListener(this.mSeekBarChangeListener);
        this.mHorizontalCurrentTimeView = (TextView)this.findViewById(R.id.tv_horizontal_controller_current_time);
        this.mHorizontalTotalTimeView = (TextView)this.findViewById(R.id.tv_horizontal_controller_total_time);
        this.mVerticalCurrentTimeView = (TextView)this.findViewById(R.id.tv_portrait_controller_current_time);
        this.mVerticalTotalTimeView = (TextView)this.findViewById(R.id.tv_portrait_controller_total_time);
        this.mCurrentPlaySpeedView = (TextView)this.findViewById(R.id.tv_horizontal_controller_speed);
        this.mCurrentPlayDefinitionView = (TextView)this.findViewById(R.id.tv_horizontal_controller_definition);
        this.mVideosListShowView = this.findViewById(R.id.chk_horizontal_controller_videos);
        this.mHorizontalStatusImg = (ImageView)this.findViewById(R.id.chk_horizontal_controller_start);
        this.mVerticalStatusImg = (ImageView)this.findViewById(R.id.icon_portrait_pause_btn);
        this.mHorizontalNextLessonImg = (ImageView)this.findViewById(R.id.chk_horizontal_controller_next_lesson);
        this.mVerticalReplayView = (ImageView)this.findViewById(R.id.portrait_controller_replay_view);
        this.mHorizontalReplayView = (ImageView)this.findViewById(R.id.horizontal_controller_replay_view);
        this.mLockedSeekBar = (SeekBar)this.mBottomLockedView.findViewById(R.id.lock_sbar_controller);
        this.mHorizontalPipView = this.findViewById(R.id.icon_horizontal_top_play_window);
        this.mPortraitPipView = this.findViewById(R.id.iv_portrait_pip);
        this.setMediaControllerOrientation(false);
        this.mSeekBar = this.getResources().getConfiguration().orientation == 2 ? this.mHorizontalSeekBar : this.mOrientalSeekBar;
        this.mFullScreenView.setOnClickListener((View.OnClickListener)this);
        this.mCurrentPlaySpeedView.setOnClickListener((View.OnClickListener)this);
        this.mCurrentPlayDefinitionView.setOnClickListener((View.OnClickListener)this);
        this.mVideosListShowView.setOnClickListener((View.OnClickListener)this);
        this.mHorizontalStatusImg.setOnClickListener((View.OnClickListener)this);
        this.mVerticalStatusImg.setOnClickListener((View.OnClickListener)this);
        this.mHorizontalNextLessonImg.setOnClickListener((View.OnClickListener)this);
        this.mTopBackView.setOnClickListener((View.OnClickListener)this);
        this.mVerticalReplayView.setOnClickListener((View.OnClickListener)this);
        this.mHorizontalReplayView.setOnClickListener((View.OnClickListener)this);
        this.mTopLayout.setVisibility(8);
        this.mBottomLayout.setVisibility(8);
        this.mTopCastView.setOnClickListener((View.OnClickListener)this);
    }

    public void setLockedRightLayoutVisible(boolean isVisible) {
        if (isVisible) {
            this.mLockedRightLayout.setVisibility(0);
        } else {
            this.mLockedRightLayout.setVisibility(4);
        }
    }

    private void setBottomLayoutByLockState(boolean isLocked) {
        if (isLocked) {
            this.mIsLocked = true;
            this.mSeekBar = this.mLockedSeekBar;
            this.hideWithOutAnimation();
            this.mBottomLockedView.setVisibility(0);
        } else {
            this.mIsLocked = false;
            this.mSeekBar = this.mHorizontalSeekBar;
            this.mBottomLockedView.setVisibility(4);
            this.showWithAnimation();
        }
    }

    private void addLockView() {
        this.mLockVideoCbx = new CheckBox(this.mContext);
        this.mLockVideoCbx.setChecked(false);
        this.mLockVideoCbx.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (VideoMediaController.this.mOnEventListener != null) {
                    VideoMediaController.this.mOnEventListener.onSetLockEnable(isChecked);
                }
                VideoMediaController.this.setBottomLayoutByLockState(isChecked);
            }
        });
        this.mLockVideoCbx.setButtonDrawable((Drawable)new ColorDrawable(0));
        this.mLockVideoCbx.setBackground(this.mContext.getResources().getDrawable(R.drawable.video_lock_state_selector));
        this.mLockedRightLayout.addView((View)this.mLockVideoCbx);
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mLockVideoCbx.getLayoutParams();
        layoutParams.addRule(15);
        layoutParams.rightMargin = DisplayUtils.dip2px((Context)this.mContext, (float)25.0f);
        this.mLockVideoCbx.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void setVideoLockState(boolean isLock) {
        if (this.mLockVideoCbx != null) {
            this.mLockVideoCbx.setChecked(isLock);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btn_toggle_screen) {
            if (this.getResources().getConfiguration().orientation == 2) {
                this.setVideoLockState(false);
            } else if (this.mLockVideoCbx == null) {
                this.addLockView();
            }
            if (this.mOnEventListener != null) {
                this.mOnEventListener.onFullScreenClick();
            }
        } else if (id2 == R.id.tv_horizontal_controller_speed) {
            this.setLockedRightLayoutVisible(false);
            this.setRightViewVisible(false);
            this.setRightViewVisible(true);
            if (this.mSpeedControlRootView == null) {
                CourseVideoPlaySpeedView courseVideoPlaySpeedView = new CourseVideoPlaySpeedView(this.mContext);
                this.mRightLayout.addView((View)courseVideoPlaySpeedView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, DisplayUtils.getScreenHeight((Context)this.getContext())));
                courseVideoPlaySpeedView.setOnCourseVideoSpeedItemClickListener(new BaseVideoPlaySpeedView.OnCourseVideoSpeedItemClickListener(){

                    public void onCourseVideoSpeedClick(float rate, String rateText) {
                        switch (rateText) {
                            case "0.8X": {
                                StatAgent.onEvent((Context)VideoMediaController.this.getContext(), (String)"FullScreen_SpeedPlayback_click0.8x");
                                break;
                            }
                            case "1.0X": {
                                StatAgent.onEvent((Context)VideoMediaController.this.getContext(), (String)"FullScreen_SpeedPlayback_click1.0x");
                                break;
                            }
                            case "1.2X": {
                                StatAgent.onEvent((Context)VideoMediaController.this.getContext(), (String)"FullScreen_SpeedPlayback_click1.2x");
                                break;
                            }
                            case "1.3X": {
                                StatAgent.onEvent((Context)VideoMediaController.this.getContext(), (String)"FullScreen_SpeedPlayback_click1.3x");
                                break;
                            }
                            case "1.5X": {
                                StatAgent.onEvent((Context)VideoMediaController.this.getContext(), (String)"FullScreen_SpeedPlayback_click1.5x");
                                break;
                            }
                            case "2.0X": {
                                StatAgent.onEvent((Context)VideoMediaController.this.getContext(), (String)"FullScreen_SpeedPlayback_click2.0x");
                                break;
                            }
                        }
                        VideoMediaController.this.mCommonVideoView.setRate(rate);
                        VideoMediaController.this.mCurrentPlaySpeedView.setText((CharSequence)rateText);
                        VideoMediaController.this.setRightViewVisible(false);
                    }
                });
                courseVideoPlaySpeedView.setCurrentSelectedView(PrefUtils.getMediaPlaySpeed((Context)this.mContext));
                this.mSpeedControlRootView = this.mRightLayout.findViewById(R.id.course_horizontal_video_speed_root_view);
            }
            this.mSpeedControlRootView.setVisibility(0);
        } else if (id2 == R.id.tv_horizontal_controller_definition) {
            this.setLockedRightLayoutVisible(false);
            this.setRightViewVisible(false);
            this.setRightViewVisible(true);
            if (this.mPlayDefinitionRootView == null) {
                this.mCourseVideoDefinitionView = new CourseVideoDefinitionView(this.mContext);
                this.mRightLayout.addView((View)this.mCourseVideoDefinitionView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, DisplayUtils.getScreenHeight((Context)this.getContext())));
                this.mCourseVideoDefinitionView.setOnCourseVideoDefinitionClickListener(new CourseVideoDefinitionView.OnCourseVideoDefinitionClickListener(){

                    public void onCourseVideoDefinitionClick(int clickDefinitionType) {
                        VideoMediaController.this.setCurrentPlayDefinitionViewText(clickDefinitionType);
                        PrefUtils.setVideoDefinition((Context)VideoMediaController.this.mContext, (int)clickDefinitionType);
                        switch (clickDefinitionType) {
                            case 1: {
                                StatAgent.onEvent((Context)VideoMediaController.this.getContext(), (String)"FullScreen_VideoResolution_clickUltra");
                                break;
                            }
                            case 2: {
                                StatAgent.onEvent((Context)VideoMediaController.this.getContext(), (String)"FullScreen_VideoResolution_clickHD");
                                break;
                            }
                            case 3: {
                                StatAgent.onEvent((Context)VideoMediaController.this.getContext(), (String)"FullScreen_VideoResolution_clickSD");
                                break;
                            }
                        }
                        VideoMediaController.this.saveCurrentVideoPlayProgress();
                        VideoMediaController.this.setPlayVideoPath(false);
                        VideoMediaController.this.setRightViewVisible(false);
                    }
                });
                this.mPlayDefinitionRootView = this.mRightLayout.findViewById(R.id.course_horizontal_definition_root_view);
            }
            if (this.mCourseVideoDefinitionView != null) {
                this.mCourseVideoDefinitionView.setAllVideoDefinition(this.mPlayListController.getCurrentPlayItem().getVideoUrlByDefinition(1), this.mPlayListController.getCurrentPlayItem().getVideoUrlByDefinition(2), this.mPlayListController.getCurrentPlayItem().getVideoUrlByDefinition(3), PrefUtils.getVideoDefinition((Context)this.mContext));
            }
            this.mPlayDefinitionRootView.setVisibility(0);
        } else if (id2 == R.id.chk_horizontal_controller_videos) {
            this.setLockedRightLayoutVisible(false);
            this.setRightViewVisible(false);
            this.setRightViewVisible(true);
            if (this.mVideosListRootView == null) {
                LayoutInflater.from((Context)this.mContext).inflate(R.layout.pc_course_horizontal_videos_list_layout, (ViewGroup)this.mRightLayout, true);
                this.mVideosListRootView = this.mRightLayout.findViewById(R.id.course_horizontal_videos_list_root_view);
                RecyclerView recyclerView = (RecyclerView)this.mRightLayout.findViewById(R.id.course_horizontal_videos_recycler_view);
                LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.mContext);
                linearLayoutManager.setAutoMeasureEnabled(true);
                recyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
                this.mVideoPlayListAdapter = new VideosPlayListAdapter(this.mContext);
                this.mVideoPlayListAdapter.setData(this.mPlayListController.getPlayList());
                recyclerView.setAdapter((RecyclerView.Adapter)this.mVideoPlayListAdapter);
                this.mVideoPlayListAdapter.setOnItemClickListener(new VideosPlayListAdapter.OnItemClickListener(){

                    @Override
                    public void onItemClick(int position) {
                        if (position != VideoMediaController.this.mPlayListController.getCurrentPlayPosition()) {
                            if (VideoMediaController.this.mOnEventListener != null) {
                                VideoMediaController.this.mOnEventListener.onVideosItemListClick(position);
                            }
                            VideoMediaController.this.setPlayVideoByPos(position);
                        }
                    }
                });
                if (this.getCurrentPlayListItem() != null) {
                    this.mVideoPlayListAdapter.updatePlayPosition(this.mPlayListController.getCurrentPlayPosition());
                }
            } else if (this.mVideoPlayListAdapter != null && this.getCurrentPlayListItem() != null) {
                this.mVideoPlayListAdapter.updatePlayPosition(this.mPlayListController.getCurrentPlayPosition());
                this.mVideoPlayListAdapter.notifyDataSetChanged();
            }
            this.mVideosListRootView.setVisibility(0);
        } else if (id2 == R.id.chk_horizontal_controller_start || id2 == R.id.icon_portrait_pause_btn) {
            this.performDoubleClickWithHide();
        } else if (id2 == R.id.chk_horizontal_controller_next_lesson) {
            this.playNextLesson();
        } else if (id2 == R.id.icon_video_controller_back_img) {
            Log.e((String)"TAG", (String)"  onClick ");
            if (this.mOnEventListener != null) {
                this.mOnEventListener.onBackClick();
            }
        } else if (id2 == R.id.portrait_controller_replay_view || id2 == R.id.horizontal_controller_replay_view) {
            this.setPlayVideoPath(true);
        } else if (id2 == R.id.btn_see_more) {
            if (this.mSeeMoreClickListener != null) {
                this.mSeeMoreClickListener.onClick(v);
            }
        } else if (id2 == R.id.icon_portrait_controller_cast && this.mOnCastViewClickListener != null) {
            this.mOnCastViewClickListener.onCastViewClicked(v);
        }
    }

    private void initMediaPlaySpeed() {
        int playSpeed = PrefUtils.getMediaPlaySpeed((Context)this.mContext);
        String playSpeedText = CourseVideoPlaySpeedView.rateSelectText[1];
        float currentRate = CourseVideoPlaySpeedView.rateSelect[1];
        switch (playSpeed) {
            case 0: {
                currentRate = CourseVideoPlaySpeedView.rateSelect[0];
                playSpeedText = CourseVideoPlaySpeedView.rateSelectText[0];
                break;
            }
            case 1: {
                currentRate = CourseVideoPlaySpeedView.rateSelect[1];
                playSpeedText = CourseVideoPlaySpeedView.rateSelectText[1];
                break;
            }
            case 2: {
                currentRate = CourseVideoPlaySpeedView.rateSelect[2];
                playSpeedText = CourseVideoPlaySpeedView.rateSelectText[2];
                break;
            }
            case 3: {
                currentRate = CourseVideoPlaySpeedView.rateSelect[3];
                playSpeedText = CourseVideoPlaySpeedView.rateSelectText[3];
                break;
            }
            case 4: {
                currentRate = CourseVideoPlaySpeedView.rateSelect[4];
                playSpeedText = CourseVideoPlaySpeedView.rateSelectText[4];
                break;
            }
            case 5: {
                currentRate = CourseVideoPlaySpeedView.rateSelect[5];
                playSpeedText = CourseVideoPlaySpeedView.rateSelectText[5];
                break;
            }
        }
        this.mCommonVideoView.setRate(currentRate);
        this.mCurrentPlaySpeedView.setText((CharSequence)playSpeedText);
    }

    private void initPlayDefinition() {
        this.setCurrentPlayDefinitionViewText(PrefUtils.getVideoDefinition((Context)this.mContext));
    }

    private void setCurrentPlayDefinitionViewText(int definitionType) {
        switch (definitionType) {
            case 1: {
                this.mCurrentPlayDefinitionView.setText((CharSequence)"\u8d85\u6e05");
                break;
            }
            case 2: {
                this.mCurrentPlayDefinitionView.setText((CharSequence)"\u9ad8\u6e05");
                break;
            }
            case 3: {
                this.mCurrentPlayDefinitionView.setText((CharSequence)"\u6807\u6e05");
                break;
            }
        }
    }

    public void setPlayVideoByPos(int position) {
        this.mPlayListController.setCurrentPlayPosition(position);
        this.saveCurrentVideoPlayProgress();
        this.setPlayVideoPath(true);
        this.setRightViewVisible(false);
    }

    private void playNextLesson() {
        BasePlayListItem playListItem = this.mPlayListController.getNextPlayItem();
        if (playListItem != null) {
            if (!playListItem.isValidVideo()) {
                ToastUtil.showMessage((Context)this.getContext(), (CharSequence)"\u4e0b\u4e00\u8bb2\u89c6\u9891\u8d44\u6e90\u5f02\u5e38\uff01");
                return;
            }
            if (this.mOnEventListener != null) {
                this.mOnEventListener.onNextPlayLessonClick(this.mPlayListController.getCurrentPlayPosition());
            }
            this.saveCurrentVideoPlayProgress();
            this.setPlayVideoPath(true);
        } else {
            ToastUtil.showMessage((Context)this.getContext(), (CharSequence)"\u5f53\u524d\u5df2\u662f\u6700\u540e\u4e00\u8bb2\uff01");
        }
    }

    private void setCurrentStartPosition() {
    }

    public void saveCurrentVideoPlayProgress() {
    }

    private void setReplayViewVisible(boolean isShowReplay) {
        if (isShowReplay) {
            this.mHorizontalReplayView.setVisibility(0);
            this.mHorizontalStatusImg.setVisibility(4);
            this.mVerticalReplayView.setVisibility(0);
            this.mVerticalStatusImg.setVisibility(8);
        } else {
            this.mHorizontalStatusImg.setVisibility(0);
            this.mHorizontalReplayView.setVisibility(4);
            this.mVerticalStatusImg.setVisibility(0);
            this.mVerticalReplayView.setVisibility(8);
        }
    }

    public void onVideoPlayComplete() {
        this.setReplayViewVisible(true);
        this.setVideoLockState(false);
        this.showWithOutAnimation();
    }

    protected void setVideoContinuePlayWithDrag() {
        this.setReplayViewVisible(false);
        this.hide();
    }

    protected void showCurrentProgressText(long currentProgress) {
        if (this.getResources().getConfiguration().orientation == 2) {
            this.mHorizontalCurrentTimeView.setText((CharSequence)StringUtils.generateTime((long)currentProgress));
        } else {
            this.mVerticalCurrentTimeView.setText((CharSequence)StringUtils.generateTime((long)currentProgress));
        }
    }

    protected void showTotalProgressText(long totalDuration) {
        if (this.getResources().getConfiguration().orientation == 2) {
            this.mHorizontalTotalTimeView.setText((CharSequence)StringUtils.generateTime((long)totalDuration));
        } else {
            this.mVerticalTotalTimeView.setText((CharSequence)StringUtils.generateTime((long)totalDuration));
        }
    }

    public void setMediaControllerOrientation(boolean landscape) {
        if (landscape) {
            if (this.isVideoLocked()) {
                this.mSeekBar = this.mLockedSeekBar;
                this.mBottomLockedView.setVisibility(0);
            } else {
                this.mSeekBar = this.mHorizontalSeekBar;
                this.mBottomHorizontalView.setVisibility(0);
            }
            this.mBottomVerticalView.setVisibility(8);
            this.setLockedRightLayoutVisible(true);
        } else {
            this.mSeekBar = this.mOrientalSeekBar;
            this.mBottomVerticalView.setVisibility(0);
            this.mBottomHorizontalView.setVisibility(8);
            this.mBottomLockedView.setVisibility(8);
            this.setRightViewVisible(false);
            this.setVideoLockState(false);
            this.setLockedRightLayoutVisible(false);
        }
        this.updateSeekBarProgress();
    }

    private int getVideoMode(String mVideoUrl) {
        return !TextUtils.isEmpty((CharSequence)mVideoUrl) && !mVideoUrl.startsWith("http") ? 1 : 2;
    }

    public boolean isPlayLocalVideo(String mVideoUrl) {
        return !TextUtils.isEmpty((CharSequence)mVideoUrl) && !mVideoUrl.startsWith("http");
    }

    protected void setRightViewVisible(boolean isVisible) {
        if (isVisible) {
            this.mRightLayout.setVisibility(0);
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mRightLayout.getLayoutParams();
            layoutParams.height = -1;
            this.mRightLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mRightLayout.requestLayout();
            this.animatorHideQrCodeImage();
        } else {
            this.mRightLayout.setVisibility(8);
            if (this.mSpeedControlRootView != null) {
                this.mSpeedControlRootView.setVisibility(8);
            }
            if (this.mPlayDefinitionRootView != null) {
                this.mPlayDefinitionRootView.setVisibility(8);
            }
            if (this.mVideosListRootView != null) {
                this.mVideosListRootView.setVisibility(8);
            }
            if (!this.isTimerFinished) {
                this.animatorShowQrCodeImage();
            }
        }
    }

    private boolean isContentShow() {
        return this.mContentPlayCompletionRootView != null && this.mContentPlayCompletionRootView.getVisibility() == 0 || this.mContentLoadVideoErrorView != null && this.mContentLoadVideoErrorView.getVisibility() == 0 || this.mContentMobileNetNoticeRootView != null && this.mContentMobileNetNoticeRootView.getVisibility() == 0;
    }

    public boolean isVideoLocked() {
        return this.mLockVideoCbx != null && this.mLockVideoCbx.isChecked();
    }

    public boolean performClick() {
        if (this.isContentShow()) {
            return false;
        }
        if (this.mRightLayout.getVisibility() == 0) {
            this.setRightViewVisible(false);
            return false;
        }
        return super.performClick();
    }

    protected void performDoubleClick() {
        if (!this.isContentShow()) {
            super.performDoubleClick();
            this.setPlayStatus(this.mCommonVideoView.isPlaying());
        }
    }

    public void pauseMediaByOtherClick() {
        if (this.mCommonVideoView != null && this.mCommonVideoView.isPlaying()) {
            this.performDoubleClickWithHide();
            this.setPlayStatus(this.mCommonVideoView.isPlaying());
        }
    }

    public void resumeMediaByOtherClick() {
        if (this.mCommonVideoView != null && !this.mCommonVideoView.isPlaying()) {
            this.performDoubleClickWithHide();
            this.setPlayStatus(this.mCommonVideoView.isPlaying());
        }
    }

    public void setPlayStatus(boolean isPlaying) {
        if (isPlaying) {
            this.mHorizontalStatusImg.setImageResource(R.mipmap.pc_horizontal_media_controller_play_icon);
            this.mVerticalStatusImg.setImageResource(R.mipmap.pc_vertical_media_controller_play_icon);
        } else {
            this.mHorizontalStatusImg.setImageResource(R.mipmap.pc_horizontal_media_controller_pause_icon);
            this.mVerticalStatusImg.setImageResource(R.mipmap.pc_vertical_media_controller_pause_icon);
        }
    }

    public void showLoadingVideoError() {
        this.hideFirstLoading();
        if (this.mContentLoadVideoErrorView == null) {
            LayoutInflater.from((Context)this.mContext).inflate(R.layout.pc_course_video_loading_error_layout, (ViewGroup)this.mContentLayout, true);
            this.mContentLoadVideoErrorView = this.mContentLayout.findViewById(R.id.course_video_loading_error_root_view);
            View retryPlayView = this.mContentLayout.findViewById(R.id.course_video_loading_error_retry_view);
            retryPlayView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (NetworkUtil.isNetworkAvailable((Context)VideoMediaController.this.getContext())) {
                        VideoMediaController.this.setPlayVideoPath(true);
                    } else {
                        ToastUtil.showMessage((Context)VideoMediaController.this.getContext(), (CharSequence)"\u5f53\u524d\u65e0\u7f51\u7edc\uff01");
                    }
                }
            });
        } else {
            this.mContentLoadVideoErrorView.setVisibility(0);
        }
        this.setContentViewVisible(true);
    }

    public void showLoadingMobileNetNotice() {
        this.pauseMediaByOtherClick();
        this.hideFirstLoading();
        if (this.mContentMobileNetNoticeRootView == null) {
            LayoutInflater.from((Context)this.mContext).inflate(R.layout.pc_course_video_mobile_net_notice_layout, (ViewGroup)this.mContentLayout, true);
            this.mContentMobileNetNoticeRootView = this.mContentLayout.findViewById(R.id.course_video_mobile_net_notice_root_view);
            this.mContentMobileNetNoticeRootView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                }
            });
            View continuePlayView = this.mContentLayout.findViewById(R.id.course_video_mobile_net_continue_view);
            continuePlayView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ServiceFactory.getAppService().setIsAllowMobileNetPlayVideo(VideoMediaController.this.mContext, true);
                    VideoMediaController.this.setPlayVideoPath(true);
                }
            });
        }
        this.mContentMobileNetNoticeRootView.setVisibility(0);
        this.setContentViewVisible(true);
    }

    protected void setContentViewVisible(boolean isVisible) {
        if (isVisible) {
            this.mContentLayout.setVisibility(0);
        } else {
            this.mContentLayout.setVisibility(8);
            if (this.mContentPlayCompletionRootView != null) {
                this.mContentPlayCompletionRootView.setVisibility(8);
            }
            if (this.mContentLoadVideoErrorView != null) {
                this.mContentLoadVideoErrorView.setVisibility(8);
            }
            if (this.mContentMobileNetNoticeRootView != null) {
                this.mContentMobileNetNoticeRootView.setVisibility(8);
            }
        }
    }

    public void showCompletionView() {
        BasePlayListItem playListItem = this.mPlayListController.getCurrentPlayItem();
        if (playListItem != null) {
            // empty if block
        }
        this.setContentViewVisible(true);
    }

    protected long preformUpdateProgress() {
        long current = super.preformUpdateProgress();
        Log.d((String)TAG, (String)("preformUpdateProgress: " + current + "/" + this.mShowQrCodeIv + "/" + this.mQrCodeImageUrl));
        if (current / 1000L == 25L && this.mShowQrCodeIv && !TextUtils.isEmpty((CharSequence)this.mQrCodeImageUrl)) {
            int count = PrefUtils.getCourseQrCodeShowCounts((Context)this.mContext, (int)this.mSecondCategory);
            PrefUtils.setCourseQrCodeShowCounts((Context)this.mContext, (int)this.mSecondCategory, (int)(count + 1));
            this.showQrCodeImage();
            this.mShowQrCodeIv = false;
        }
        return current;
    }

    public void setQrCodeImageUrl(String qrCodeImageUrl) {
        this.mQrCodeImageUrl = qrCodeImageUrl;
        this.mShowQrCodeIv = true;
    }

    private void showQrCodeImage() {
        Log.d((String)TAG, (String)"showQrCodeImage: ");
        this.mQrCodeIv.setImageDrawable(null);
        this.mQrCodeIv.setVisibility(0);
        Glide.with((Context)this.getContext()).load(this.mQrCodeImageUrl).into(this.mQrCodeIv);
        if (this.mDownTimer != null) {
            this.mDownTimer.cancel();
            this.mDownTimer = null;
        }
        this.mDownTimer = new CountDownTimer(20001L, 1000L){

            public void onTick(long millisUntilFinished) {
            }

            public void onFinish() {
                VideoMediaController.this.isTimerFinished = true;
                VideoMediaController.this.animatorHideQrCodeImage();
            }
        };
        this.isTimerFinished = false;
        this.mDownTimer.start();
    }

    public void hideQrCodeImageImmediately() {
        if (this.mDownTimer != null) {
            this.mDownTimer.cancel();
            this.mDownTimer = null;
        }
        this.mQrCodeIv.setVisibility(8);
    }

    public void setVideoPlayListView(boolean isVisible) {
        if (isVisible) {
            this.mVideosListShowView.setVisibility(0);
        } else {
            this.mVideosListShowView.setVisibility(8);
        }
    }

    public void hideDefinitionView() {
        this.mCurrentPlayDefinitionView.setVisibility(8);
    }

    public void showDefinitionView() {
        this.mCurrentPlayDefinitionView.setVisibility(0);
    }

    public void showSeeMoreButton() {
        this.isShowSeeMoreButton = true;
        this.mSeeMoreBtn.startAnimation(this.mRightInAnimation);
        this.mSeeMoreBtn.setVisibility(0);
    }

    public void hideSeeMoreButton() {
        this.isShowSeeMoreButton = false;
        if (this.mSeeMoreBtn.getVisibility() == 0) {
            this.mSeeMoreBtn.startAnimation(this.mRightOutAnimation);
        }
    }

    private void animatorHideQrCodeImage() {
        if (this.mQrCodeIv.getVisibility() == 8 || this.mQrCodeIv.getVisibility() == 4) {
            return;
        }
        Animation animation = android.view.animation.AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.fade_out);
        this.mQrCodeIv.setAnimation(animation);
        animation.start();
        this.mQrCodeIv.setVisibility(8);
    }

    private void animatorShowQrCodeImage() {
        Animation animation = android.view.animation.AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.fade_in);
        this.mQrCodeIv.setAnimation(animation);
        animation.start();
        this.mQrCodeIv.setVisibility(0);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.signalDelayedHandler != null) {
            this.signalDelayedHandler.removeCallbacksAndMessages(null);
        }
    }

    public void startUploadVideoLog() {
        if (this.signalDelayedHandler != null && !this.signalDelayedHandler.hasMessages(6) && NetworkUtil.isNetworkAvailable((Context)this.mContext)) {
            this.signalDelayedHandler.sendSignalMessageDelayed(this.signalDelayedHandler.obtainMessage(6), 300000L);
        }
    }

    protected void onHandleSignMessage(CommonVideoController reference, Message msg) {
        super.onHandleSignMessage(reference, msg);
        switch (msg.what) {
            case 6: {
                if (!NetworkUtil.isNetworkAvailable((Context)this.mContext) || this.mOnEventListener == null) break;
                this.mOnEventListener.onUploadByIntervalHandler();
                this.signalDelayedHandler.sendSignalMessageDelayed(this.signalDelayedHandler.obtainMessage(6), 300000L);
                break;
            }
            case 8: {
                if (this.mOnEventListener == null) break;
                this.mOnEventListener.onStartDragSeekBar();
                break;
            }
        }
    }

    public void setOnEventListener(OnEventListener onEventListener) {
        this.mOnEventListener = onEventListener;
    }

    public void setSeeMoreClickListener(View.OnClickListener seeMoreClickListener) {
        this.mSeeMoreClickListener = seeMoreClickListener;
    }

    private void initAnimation() {
        this.mRightInAnimation = android.view.animation.AnimationUtils.loadAnimation((Context)this.getContext(), (int)17432578);
        this.mRightInAnimation.setDuration(this.mTopIn.getDuration());
        this.mRightOutAnimation = android.view.animation.AnimationUtils.loadAnimation((Context)this.getContext(), (int)17432579);
        this.mRightOutAnimation.setAnimationListener(this.mRightOutAnimationListener);
        this.mRightOutAnimation.setDuration(this.mTopOut.getDuration());
        this.mBottomInAnimator = AnimationUtils.getBottomInAnimator((Context)this.mContext, (View)this.mBottomLayout, (long)500L);
        this.mBottomOutAnimator = AnimationUtils.getBottomOutAnimator((Context)this.mContext, (View)this.mBottomLayout, (long)500L);
    }

    protected void onToolBarAnimationIn() {
        this.mTopMediaController.setVisibility(0);
        this.mBottomMediaController.setVisibility(0);
        this.mTopMediaController.startAnimation((Animation)this.mTopIn);
        this.mBottomInAnimator.start();
    }

    protected void onToolBarAnimationOut() {
        this.mTopMediaController.startAnimation((Animation)this.mTopOut);
        this.mBottomOutAnimator.start();
    }

    public void hideWithOutAnimation() {
        super.hideWithOutAnimation();
    }

    public BasePlayListItem getCurrentPlayListItem() {
        return this.mPlayListController.getCurrentPlayItem();
    }

    public void setOnCastViewClickListener(OnCastViewClickListener onCastViewClickListener) {
        this.mOnCastViewClickListener = onCastViewClickListener;
    }

    public void showCastView() {
        this.mTopCastView.setVisibility(0);
    }

    public RelativeLayout getBottomLayout() {
        return this.mBottomLayout;
    }

    public void hidePipView() {
        if (this.mPortraitPipView != null) {
            this.mPortraitPipView.setVisibility(8);
        }
        if (this.mHorizontalPipView != null) {
            this.mHorizontalPipView.setVisibility(8);
        }
    }

    public static interface OnCastViewClickListener {
        public void onCastViewClicked(View var1);
    }

    public static interface OnEventListener {
        public void onBackClick();

        public void onUploadByIntervalHandler();

        public void onFullScreenClick();

        public void onNextPlayLessonClick(int var1);

        public void onStartDragSeekBar();

        public void onSetLockEnable(boolean var1);

        public void onVideosItemListClick(int var1);
    }
}

