/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.widget.edittext;

import android.content.Context;
import android.text.Editable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.LongSparseArray;
import android.view.KeyEvent;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import android.widget.EditText;
import com.edu24.data.server.discover.entity.DiscoverDynamicElement;
import com.edu24.data.server.discover.entity.DiscoverSimpleTopic;
import com.edu24.data.server.discover.entity.DiscoverUser;
import com.edu24.data.server.discover.entity.Range;
import com.edu24ol.newclass.discover.text.AtUserClickableSpan;
import com.edu24ol.newclass.discover.text.TopicClickableSpan;
import com.hqwx.android.platform.utils.ToastUtil;
import com.hqwx.android.platform.widgets.text.editText.MaxCountLimitEditText;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DynamicEditText
extends MaxCountLimitEditText {
    private DynamicElementsInfo mTopicElementsInfo = new DynamicElementsInfo();
    private DynamicElementsInfo mUserElementsInfo = new DynamicElementsInfo();
    private boolean mIsSelected;
    private Range mLastSelectedRange;
    private InputConnectionWrapper mInputConnection;
    private EventListener mEventListener;

    public DynamicEditText(Context context) {
        this(context, null);
    }

    public DynamicEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DynamicEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setText(String text, List<DiscoverSimpleTopic> topics, List<DiscoverUser> atUsers) {
        if (topics != null && topics.size() > 0) {
            for (DiscoverSimpleTopic topic : topics) {
                this.addToElementsList(text, (DiscoverDynamicElement)topic, this.mTopicElementsInfo);
            }
        }
        if (atUsers != null && atUsers.size() > 0) {
            for (DiscoverUser atUser : atUsers) {
                this.addToElementsList(text, (DiscoverDynamicElement)atUser, this.mUserElementsInfo);
            }
        }
        this.setText(text);
    }

    private Range getElementRangeInText(String text, Pattern elementPattern) {
        Matcher matcher = elementPattern.matcher(text);
        if (matcher.find()) {
            String mentionText = matcher.group();
            int start = text.indexOf(mentionText);
            int end = start + mentionText.length();
            Range range = new Range(start, end);
            return range;
        }
        return null;
    }

    public void addTopics(List<DiscoverSimpleTopic> topics) {
        for (DiscoverSimpleTopic topic : topics) {
            this.addTopic(topic);
        }
    }

    public void addElement(DiscoverDynamicElement element, DynamicElementsInfo targetDynamicElementsInfo) {
        String insertText = element.getInsertText();
        if (this.getText().toString().length() - 1 + insertText.length() > this.getMaxLength()) {
            ToastUtil.showMessage((Context)this.getContext(), (CharSequence)"\u5b57\u6570\u8d85\u51fa\uff0c\u6dfb\u52a0\u5931\u8d25!");
            return;
        }
        this.addToElementsList(element, targetDynamicElementsInfo);
        this.addElementText(element, targetDynamicElementsInfo);
    }

    private void addElementText(DiscoverDynamicElement element, DynamicElementsInfo targetDynamicElementsInfo) {
        String preTextBeforeSelectionPosition;
        String insertText = element.getInsertText();
        int selectionStart = this.getSelectionStart();
        String string2 = preTextBeforeSelectionPosition = selectionStart > 0 ? this.getText().toString().substring(selectionStart - 1, selectionStart) : "";
        if (selectionStart > 0 && preTextBeforeSelectionPosition.equals(element.getBeginPatternSign())) {
            int start = selectionStart - 1;
            int end = start + insertText.length();
            Range range = new Range(start, end);
            targetDynamicElementsInfo.mRangeList.put(element.getId(), (Object)range);
            this.getText().replace(selectionStart - 1, selectionStart, (CharSequence)insertText);
        } else {
            int start = selectionStart;
            int end = start + insertText.length();
            Range range = new Range(start, end);
            targetDynamicElementsInfo.mRangeList.put(element.getId(), (Object)range);
            this.getText().insert(selectionStart, (CharSequence)insertText);
        }
    }

    private void addToElementsList(String text, DiscoverDynamicElement element, DynamicElementsInfo dynamicElementsInfo) {
        this.addToElementsList(element, dynamicElementsInfo);
        Range range = this.getElementRangeInText(text, (Pattern)dynamicElementsInfo.mPattern.get(element.getId()));
        if (range != null) {
            dynamicElementsInfo.mRangeList.put(element.getId(), (Object)range);
        }
    }

    private void addToElementsList(DiscoverDynamicElement element, DynamicElementsInfo dynamicElementsInfo) {
        Pattern pattern = Pattern.compile(element.getPatternString());
        dynamicElementsInfo.mElements.put(element.getId(), (Object)element);
        dynamicElementsInfo.mPattern.put(element.getId(), (Object)pattern);
    }

    public void addTopic(DiscoverSimpleTopic topic) {
        this.addElement((DiscoverDynamicElement)topic, this.mTopicElementsInfo);
    }

    public void addATUsers(List<DiscoverUser> atUsers) {
        for (DiscoverUser ATUser : atUsers) {
            this.addATUser(ATUser);
        }
    }

    public void addATUser(DiscoverUser atUser) {
        this.addElement((DiscoverDynamicElement)atUser, this.mUserElementsInfo);
    }

    public LongSparseArray<? extends DiscoverDynamicElement> getTopics() {
        return this.mTopicElementsInfo.mElements;
    }

    public LongSparseArray<? extends DiscoverDynamicElement> getATUsers() {
        return this.mUserElementsInfo.mElements;
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        Range nearbyRange;
        super.onSelectionChanged(selStart, selEnd);
        if (this.mLastSelectedRange != null && this.mLastSelectedRange.isEqual(selStart, selEnd)) {
            return;
        }
        Range closestRange = this.getRangeOfClosestMentionString(selStart, selEnd);
        if (closestRange != null && closestRange.to == selEnd) {
            this.mIsSelected = false;
        }
        if ((nearbyRange = this.getRangeOfNearbyMentionString(selStart, selEnd)) == null) {
            return;
        }
        if (selStart == selEnd) {
            this.setSelection(Math.min(this.getText().length(), nearbyRange.getAnchorPosition(selStart)));
        } else {
            if (selEnd < nearbyRange.to) {
                this.setSelection(selStart, nearbyRange.to);
            }
            if (selStart > nearbyRange.from) {
                this.setSelection(nearbyRange.from, selEnd);
            }
        }
    }

    public void onTextChanged(CharSequence charSequence, int start, int before, int count) {
        this.setupTopicAndUserHighlight();
        if (count == 1 && !TextUtils.isEmpty((CharSequence)charSequence)) {
            char mentionChar = charSequence.toString().charAt(start);
            if ("@".equals(String.valueOf(mentionChar))) {
                if (this.mEventListener != null) {
                    this.mEventListener.onTextInputATUser();
                }
            } else if ("#".equals(String.valueOf(mentionChar)) && this.mEventListener != null) {
                this.mEventListener.onTextInputTopic();
            }
        }
    }

    private void setupTopicAndUserHighlight() {
        int end;
        int start;
        String mentionText;
        int lastMentionIndex;
        Matcher matcher;
        Pattern pattern;
        int i;
        AtUserClickableSpan[] atUserClickableSpans;
        TopicClickableSpan[] oldSpans;
        if (this.mTopicElementsInfo == null || this.mUserElementsInfo == null) {
            return;
        }
        this.mIsSelected = false;
        Editable spannableText = this.getText();
        if (spannableText == null || TextUtils.isEmpty((CharSequence)spannableText.toString())) {
            return;
        }
        for (TopicClickableSpan oldSpan : oldSpans = (TopicClickableSpan[])spannableText.getSpans(0, spannableText.length(), TopicClickableSpan.class)) {
            spannableText.removeSpan((Object)oldSpan);
        }
        for (AtUserClickableSpan oldSpan : atUserClickableSpans = (AtUserClickableSpan[])spannableText.getSpans(0, spannableText.length(), AtUserClickableSpan.class)) {
            spannableText.removeSpan((Object)oldSpan);
        }
        String text = spannableText.toString();
        this.mTopicElementsInfo.mRangeList.clear();
        for (i = 0; i < this.mTopicElementsInfo.mPattern.size(); ++i) {
            long topicId = this.mTopicElementsInfo.mPattern.keyAt(i);
            pattern = (Pattern)this.mTopicElementsInfo.mPattern.valueAt(i);
            matcher = pattern.matcher(text);
            lastMentionIndex = -1;
            while (matcher.find()) {
                mentionText = matcher.group();
                start = lastMentionIndex != -1 ? text.indexOf(mentionText, lastMentionIndex) : text.indexOf(mentionText);
                end = start + mentionText.length();
                spannableText.setSpan((Object)new TopicClickableSpan(topicId), start, end, 33);
                lastMentionIndex = end;
                this.mTopicElementsInfo.mRangeList.put(topicId, (Object)new Range(start, end));
            }
        }
        for (i = 0; i < this.mUserElementsInfo.mPattern.size(); ++i) {
            long userId = this.mUserElementsInfo.mPattern.keyAt(i);
            pattern = (Pattern)this.mUserElementsInfo.mPattern.valueAt(i);
            matcher = pattern.matcher(text);
            lastMentionIndex = -1;
            while (matcher.find()) {
                mentionText = matcher.group();
                start = lastMentionIndex != -1 ? text.indexOf(mentionText, lastMentionIndex) : text.indexOf(mentionText);
                end = start + mentionText.length();
                spannableText.setSpan((Object)new AtUserClickableSpan(userId), start, end, 33);
                lastMentionIndex = end;
                this.mUserElementsInfo.mRangeList.put(userId, (Object)new Range(start, end));
            }
        }
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        this.mInputConnection = new HackInputConnection(super.onCreateInputConnection(outAttrs), true, this);
        return this.mInputConnection;
    }

    public InputConnectionWrapper getInputConnection() {
        return this.mInputConnection;
    }

    private void removeElementByRange(Range target) {
        Range range;
        int i;
        if (!(this.mTopicElementsInfo != null && this.mTopicElementsInfo.mRangeList.size() != 0 || this.mUserElementsInfo != null && this.mUserElementsInfo.mRangeList.size() != 0)) {
            return;
        }
        for (i = 0; i < this.mTopicElementsInfo.mRangeList.size(); ++i) {
            range = (Range)this.mTopicElementsInfo.mRangeList.valueAt(i);
            long topicId = this.mTopicElementsInfo.mRangeList.keyAt(i);
            if (range != target) continue;
            this.mTopicElementsInfo.removeElement(topicId);
            return;
        }
        for (i = 0; i < this.mUserElementsInfo.mRangeList.size(); ++i) {
            range = (Range)this.mUserElementsInfo.mRangeList.valueAt(i);
            long userId = this.mUserElementsInfo.mRangeList.keyAt(i);
            if (range != target) continue;
            this.mUserElementsInfo.removeElement(userId);
            return;
        }
    }

    private Range getRangeOfClosestMentionString(int selStart, int selEnd) {
        Range range;
        int i;
        if (!(this.mTopicElementsInfo != null && this.mTopicElementsInfo.mRangeList.size() != 0 || this.mUserElementsInfo != null && this.mUserElementsInfo.mRangeList.size() != 0)) {
            return null;
        }
        int start = Math.min(selStart, selEnd);
        int end = Math.max(selStart, selEnd);
        for (i = 0; i < this.mTopicElementsInfo.mRangeList.size(); ++i) {
            range = (Range)this.mTopicElementsInfo.mRangeList.valueAt(i);
            if (!range.contains(start, end)) continue;
            return range;
        }
        for (i = 0; i < this.mUserElementsInfo.mRangeList.size(); ++i) {
            range = (Range)this.mUserElementsInfo.mRangeList.valueAt(i);
            if (!range.contains(start, end)) continue;
            return range;
        }
        return null;
    }

    private Range getRangeOfNearbyMentionString(int selStart, int selEnd) {
        Range range;
        int i;
        if (!(this.mTopicElementsInfo != null && this.mTopicElementsInfo.mRangeList.size() != 0 || this.mUserElementsInfo != null && this.mUserElementsInfo.mRangeList.size() != 0)) {
            return null;
        }
        int start = Math.min(selStart, selEnd);
        int end = Math.max(selStart, selEnd);
        for (i = 0; i < this.mTopicElementsInfo.mRangeList.size(); ++i) {
            range = (Range)this.mTopicElementsInfo.mRangeList.valueAt(i);
            if (!range.isWrappedBy(start, end)) continue;
            return range;
        }
        for (i = 0; i < this.mUserElementsInfo.mRangeList.size(); ++i) {
            range = (Range)this.mUserElementsInfo.mRangeList.valueAt(i);
            if (!range.isWrappedBy(start, end)) continue;
            return range;
        }
        return null;
    }

    public void setEventListener(EventListener eventListener) {
        this.mEventListener = eventListener;
    }

    public static interface EventListener {
        public void onTextInputATUser();

        public void onTextInputTopic();
    }

    private class HackInputConnection
    extends InputConnectionWrapper {
        private EditText editText;

        HackInputConnection(InputConnection target, boolean mutable, DynamicEditText editText) {
            super(target, mutable);
            this.editText = editText;
        }

        public boolean sendKeyEvent(KeyEvent event) {
            if (event.getAction() == 0 && event.getKeyCode() == 67) {
                int selectionEnd;
                int selectionStart = this.editText.getSelectionStart();
                Range closestRange = DynamicEditText.this.getRangeOfClosestMentionString(selectionStart, selectionEnd = this.editText.getSelectionEnd());
                if (closestRange == null) {
                    DynamicEditText.this.mIsSelected = false;
                    return super.sendKeyEvent(event);
                }
                if (DynamicEditText.this.mIsSelected || selectionStart == closestRange.from) {
                    DynamicEditText.this.mIsSelected = false;
                    DynamicEditText.this.removeElementByRange(closestRange);
                    return super.sendKeyEvent(event);
                }
                DynamicEditText.this.mIsSelected = true;
                DynamicEditText.this.mLastSelectedRange = closestRange;
                this.setSelection(closestRange.to, closestRange.from);
                return true;
            }
            return super.sendKeyEvent(event);
        }

        public boolean deleteSurroundingText(int beforeLength, int afterLength) {
            if (beforeLength == 1 && afterLength == 0) {
                return this.sendKeyEvent(new KeyEvent(0, 67)) && this.sendKeyEvent(new KeyEvent(1, 67));
            }
            return super.deleteSurroundingText(beforeLength, afterLength);
        }
    }

    private static class DynamicElementsInfo {
        LongSparseArray<Pattern> mPattern = new LongSparseArray();
        LongSparseArray<Range> mRangeList = new LongSparseArray();
        LongSparseArray<DiscoverDynamicElement> mElements = new LongSparseArray();

        private DynamicElementsInfo() {
        }

        public void removeElement(long elementId) {
            this.mRangeList.remove(elementId);
            this.mPattern.remove(elementId);
            this.mElements.remove(elementId);
        }
    }
}

