/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.widget.article;

import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.widget.TextView;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24ol.newclass.discover.text.AtUserClickableSpan;
import com.edu24ol.newclass.discover.util.DiscoverSpanStringUtil;
import com.edu24ol.newclass.discover.util.DiscoverViewUtil;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.widgets.CenterAlignImageSpan;

public interface DiscoverUISetterVideoArticle {
    public void setupVideoTitleView(TextView var1, ArticleInfo var2, boolean var3);

    public static class ForwardSetter
    implements DiscoverUISetterVideoArticle {
        @Override
        public void setupVideoTitleView(TextView titleView, ArticleInfo articleInfo, boolean isShowTag) {
            String title = "@" + (articleInfo.author != null ? articleInfo.author.name : "") + ":";
            int length = title.length();
            title = title + articleInfo.title;
            SpannableString spannableString = new SpannableString((CharSequence)title);
            DiscoverSpanStringUtil.setStringArticleUserHighlight((Spannable)spannableString, articleInfo.getArticleATUsers());
            spannableString.setSpan((Object)new AtUserClickableSpan(articleInfo.getAuthorId()), 0, length, 34);
            titleView.setText((CharSequence)spannableString);
        }
    }

    public static class NormalSetter
    implements DiscoverUISetterVideoArticle {
        @Override
        public void setupVideoTitleView(TextView titleView, ArticleInfo articleInfo, boolean isShowTag) {
            if (TextUtils.isEmpty((CharSequence)articleInfo.content)) {
                // empty if block
            }
            String title = articleInfo.title;
            if (articleInfo.isStick()) {
                if (isShowTag) {
                    CenterAlignImageSpan hotImageSpan = DiscoverViewUtil.getImageSpanByDrawableId(titleView.getContext(), R.mipmap.discover_common_ic_stick_type);
                    SpannableString spannableString = new SpannableString((CharSequence)("  " + title));
                    spannableString.setSpan((Object)hotImageSpan, 0, 1, 17);
                    titleView.setText((CharSequence)spannableString);
                } else {
                    titleView.setText((CharSequence)title);
                }
            } else {
                titleView.setText((CharSequence)title);
            }
        }
    }
}

