/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.widget.article;

import android.content.Context;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.widget.TextView;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24ol.newclass.discover.text.AtUserClickableSpan;
import com.edu24ol.newclass.discover.util.DiscoverViewUtil;
import com.edu24ol.newclass.discover.widget.article.DiscoverArticleViewShort;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.widgets.CenterAlignImageSpan;

public interface DiscoverUISetterShortArticle {
    public void refreshTitle(TextView var1, TextView var2, ArticleInfo var3, boolean var4, int var5);

    public static class DetailSetter
    implements DiscoverUISetterShortArticle {
        @Override
        public void refreshTitle(TextView showTotalContentView, TextView titleTextView, ArticleInfo articleInfo, boolean isShowTag, int titleWidth) {
            if (TextUtils.isEmpty((CharSequence)articleInfo.content)) {
                return;
            }
            String title = articleInfo.content;
            SpannableString spannableString = new SpannableString((CharSequence)title);
            DiscoverArticleViewShort.setupTopicAndUserHighlight(articleInfo, (Spannable)spannableString);
            titleTextView.setText((CharSequence)spannableString);
        }
    }

    public static class ForwardSetter
    implements DiscoverUISetterShortArticle {
        @Override
        public void refreshTitle(TextView showTotalContentView, TextView titleTextView, ArticleInfo articleInfo, boolean isShowTag, int titleWidth) {
            SpannableString spannableString;
            if (TextUtils.isEmpty((CharSequence)articleInfo.content)) {
                return;
            }
            String title = "@" + (articleInfo.author != null ? articleInfo.author.name : "") + ":";
            int length = title.length();
            String closeTextString = DiscoverArticleViewShort.getCloseTextContent(titleTextView, titleWidth, 5, title = title + articleInfo.content);
            if (TextUtils.isEmpty((CharSequence)closeTextString)) {
                spannableString = new SpannableString((CharSequence)title);
                showTotalContentView.setVisibility(8);
            } else {
                spannableString = new SpannableString((CharSequence)closeTextString);
                showTotalContentView.setVisibility(0);
            }
            DiscoverArticleViewShort.setupTopicAndUserHighlight(articleInfo, (Spannable)spannableString);
            spannableString.setSpan((Object)new AtUserClickableSpan(articleInfo.getAuthorId()), 0, length, 34);
            titleTextView.setText((CharSequence)spannableString);
        }
    }

    public static class NormalSetter
    implements DiscoverUISetterShortArticle {
        @Override
        public void refreshTitle(TextView showTotalContentView, TextView titleTextView, ArticleInfo articleInfo, boolean isShowTag, int titleWidth) {
            if (TextUtils.isEmpty((CharSequence)articleInfo.content)) {
                return;
            }
            String title = articleInfo.isStick() ? (isShowTag ? "  " : "") + articleInfo.content : articleInfo.content;
            SpannableString spannableString = this.addArticleTagToText(titleTextView.getContext(), articleInfo.isStick(), isShowTag, title);
            String closeTextString = DiscoverArticleViewShort.getCloseTextContent(titleTextView, titleWidth, 5, spannableString.toString());
            if (TextUtils.isEmpty((CharSequence)closeTextString)) {
                showTotalContentView.setVisibility(8);
            } else {
                spannableString = this.addArticleTagToText(titleTextView.getContext(), articleInfo.isStick(), isShowTag, closeTextString);
                showTotalContentView.setVisibility(0);
            }
            DiscoverArticleViewShort.setupTopicAndUserHighlight(articleInfo, (Spannable)spannableString);
            titleTextView.setText((CharSequence)spannableString);
        }

        protected SpannableString addArticleTagToText(Context context, boolean isStick, boolean isShowTag, String textContent) {
            SpannableString newSpanString = new SpannableString((CharSequence)textContent);
            if (isStick && isShowTag) {
                CenterAlignImageSpan imageSpan = DiscoverViewUtil.getImageSpanByDrawableId(context, R.mipmap.discover_common_ic_stick_type);
                newSpanString.setSpan((Object)imageSpan, 0, 1, 17);
            }
            return newSpanString;
        }
    }
}

