/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.widget.article;

import android.text.SpannableString;
import android.text.TextUtils;
import android.widget.TextView;
import com.edu24.data.server.discover.entity.ArticleAuthor;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24ol.newclass.discover.text.AtUserClickableSpan;
import com.edu24ol.newclass.discover.util.DiscoverViewUtil;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.widgets.CenterAlignImageSpan;

public interface DiscoverUISetterLongArticle {
    public void refreshTitle(TextView var1, ArticleInfo var2, boolean var3);

    public static class ForwardSetter
    implements DiscoverUISetterLongArticle {
        @Override
        public void refreshTitle(TextView titleView, ArticleInfo articleInfo, boolean isShowTag) {
            if (TextUtils.isEmpty((CharSequence)articleInfo.content)) {
                return;
            }
            String title = "";
            ArticleAuthor author = articleInfo.author;
            if (author != null) {
                title = "@" + articleInfo.author.name + ":";
            }
            int length = title.length();
            title = title + articleInfo.title;
            SpannableString spannableString = new SpannableString((CharSequence)title);
            spannableString.setSpan((Object)new AtUserClickableSpan(articleInfo.getAuthorId()), 0, length, 34);
            titleView.setText((CharSequence)spannableString);
        }
    }

    public static class NormalSetter
    implements DiscoverUISetterLongArticle {
        @Override
        public void refreshTitle(TextView titleView, ArticleInfo articleInfo, boolean isShowTag) {
            String title = articleInfo.title;
            SpannableString spannableString = null;
            if (articleInfo.isStick()) {
                if (isShowTag) {
                    CenterAlignImageSpan hotImageSpan = DiscoverViewUtil.getImageSpanByDrawableId(titleView.getContext(), R.mipmap.discover_common_ic_stick_type);
                    spannableString = new SpannableString((CharSequence)("   " + title));
                    spannableString.setSpan((Object)hotImageSpan, 0, 1, 17);
                } else {
                    spannableString = new SpannableString((CharSequence)title);
                }
            } else {
                spannableString = new SpannableString((CharSequence)title);
            }
            titleView.setText((CharSequence)spannableString);
        }
    }
}

