/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.widget.article;

import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.widget.TextView;
import com.edu24.data.server.discover.entity.ArticleAuthor;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24ol.newclass.discover.text.AtUserClickableSpan;
import com.edu24ol.newclass.discover.widget.article.DiscoverArticleViewShort;

public interface DiscoverUISetterFAQArticle {
    public void refreshTitle(TextView var1, ArticleInfo var2, boolean var3);

    public void refreshContent(TextView var1, TextView var2, ArticleInfo var3, int var4);

    public static class ForwardSetter
    extends NormalSetter {
        @Override
        public void refreshTitle(TextView titleView, ArticleInfo articleInfo, boolean isShowTag) {
            String title = "";
            ArticleAuthor author = articleInfo.author;
            if (author != null) {
                title = "@" + articleInfo.author.name + ":";
            }
            int length = title.length();
            if (!TextUtils.isEmpty((CharSequence)articleInfo.title)) {
                title = title + articleInfo.title;
            }
            SpannableString spannableString = new SpannableString((CharSequence)title);
            spannableString.setSpan((Object)new AtUserClickableSpan(articleInfo.getAuthorId()), 0, length, 34);
            titleView.setText((CharSequence)spannableString);
            titleView.setVisibility(0);
        }
    }

    public static class NormalSetter
    implements DiscoverUISetterFAQArticle {
        @Override
        public void refreshTitle(TextView titleView, ArticleInfo articleInfo, boolean isShowTag) {
            if (TextUtils.isEmpty((CharSequence)articleInfo.title)) {
                titleView.setVisibility(8);
            } else {
                titleView.setVisibility(0);
                titleView.setText((CharSequence)articleInfo.title);
            }
        }

        @Override
        public void refreshContent(TextView showTotalContentView, TextView contentTextView, ArticleInfo articleInfo, int textViewWidth) {
            SpannableString spannableString;
            if (TextUtils.isEmpty((CharSequence)articleInfo.content)) {
                contentTextView.setText((CharSequence)"");
                return;
            }
            String title = articleInfo.content;
            String closeTextString = DiscoverArticleViewShort.getCloseTextContent(contentTextView, textViewWidth, 5, title);
            if (TextUtils.isEmpty((CharSequence)closeTextString)) {
                spannableString = new SpannableString((CharSequence)title);
                showTotalContentView.setVisibility(8);
            } else {
                spannableString = new SpannableString((CharSequence)closeTextString);
                showTotalContentView.setVisibility(0);
            }
            DiscoverArticleViewShort.setupTopicAndUserHighlight(articleInfo, (Spannable)spannableString);
            contentTextView.setText((CharSequence)spannableString);
        }
    }
}

