/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.widget.article;

import android.text.SpannableString;
import android.widget.TextView;
import com.edu24.data.server.discover.entity.ArticleAuthor;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24ol.newclass.discover.text.AtUserClickableSpan;

public interface DiscoverUISetterCommentArticle {
    public void refreshForwardTitle(TextView var1, ArticleInfo var2);

    public static class ForwardSetter
    implements DiscoverUISetterCommentArticle {
        @Override
        public void refreshForwardTitle(TextView titleView, ArticleInfo articleInfo) {
            ArticleAuthor author = articleInfo.author;
            if (author != null) {
                String title = "@" + articleInfo.author.name + ":";
                titleView.setVisibility(0);
                int length = title.length();
                SpannableString spannableString = new SpannableString((CharSequence)title);
                spannableString.setSpan((Object)new AtUserClickableSpan(articleInfo.getAuthorId()), 0, length, 34);
                titleView.setText((CharSequence)spannableString);
            } else {
                titleView.setVisibility(8);
            }
        }
    }

    public static class NormalSetter
    implements DiscoverUISetterCommentArticle {
        @Override
        public void refreshForwardTitle(TextView titleView, ArticleInfo articleInfo) {
            titleView.setVisibility(8);
        }
    }
}

