/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.widget.article;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.edu24.data.server.discover.entity.ArticleTopic;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.discover.common.databinding.DiscoverItemTopicContentViewBinding;
import com.hqwx.android.platform.utils.DisplayUtils;
import com.hqwx.android.platform.widgets.AbstractBaseRecycleViewAdapter;
import com.hqwx.android.platform.widgets.flowlayout.FlowLayoutManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiscoverTopicContentView
extends ConstraintLayout {
    private DiscoverItemTopicContentViewBinding mBinding;
    private TopicAdapter mTopicAdapter;
    private View.OnClickListener mTopicClickListener;

    public DiscoverTopicContentView(@NonNull @NotNull Context context) {
        this(context, null);
    }

    public DiscoverTopicContentView(@NonNull @NotNull Context context, @androidx.annotation.Nullable @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DiscoverTopicContentView(@NonNull @NotNull Context context, @androidx.annotation.Nullable @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mBinding = DiscoverItemTopicContentViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        this.mBinding.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new FlowLayoutManager());
        this.mBinding.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new SpaceItemDecoration(DisplayUtils.dip2px((Context)this.getContext(), (float)8.0f)));
        this.mTopicAdapter = new TopicAdapter(context);
        this.mBinding.recyclerView.setAdapter((RecyclerView.Adapter)this.mTopicAdapter);
    }

    public void setTopicData(List<ArticleTopic> topicList) {
        this.mTopicAdapter.setData(topicList);
        this.mTopicAdapter.notifyDataSetChanged();
    }

    public void setTopicClickListener(View.OnClickListener topicClickListener) {
        this.mTopicClickListener = topicClickListener;
    }

    private class SpaceItemDecoration
    extends RecyclerView.ItemDecoration {
        private int space;

        public SpaceItemDecoration(int space) {
            this.space = space;
        }

        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            outRect.right = this.space;
            outRect.bottom = this.space;
        }
    }

    protected class TopicAdapter
    extends AbstractBaseRecycleViewAdapter<ArticleTopic> {
        public TopicAdapter(Context context) {
            super(context);
        }

        @NonNull
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            return new ViewHolder(LayoutInflater.from((Context)this.mContext).inflate(R.layout.discover_item_topic, parent, false));
        }

        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
            TextView textView = (TextView)holder.itemView;
            ArticleTopic topic = (ArticleTopic)this.getItem(position);
            textView.setText((CharSequence)("#" + topic.getTopicName()));
            textView.setTag((Object)topic);
        }

        private class ViewHolder
        extends RecyclerView.ViewHolder {
            public ViewHolder(View itemView) {
                super(itemView);
                itemView.setOnClickListener(view -> {
                    if (DiscoverTopicContentView.this.mTopicClickListener != null) {
                        DiscoverTopicContentView.this.mTopicClickListener.onClick(view);
                    }
                });
            }
        }
    }
}

