/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.widget.article;

import android.content.Context;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24ol.newclass.discover.util.DiscoverSpanStringUtil;
import com.hqwx.android.discover.common.R;

public class DiscoverForwardContentView
extends LinearLayout {
    protected TextView mForwardContentText;

    public DiscoverForwardContentView(@NonNull Context context) {
        this(context, null);
    }

    public DiscoverForwardContentView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DiscoverForwardContentView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initViews();
    }

    protected void initViews() {
        this.setOrientation(1);
        View itemView = LayoutInflater.from((Context)this.getContext()).inflate(this.getContentLayoutId(), (ViewGroup)this, true);
        this.mForwardContentText = (TextView)itemView.findViewById(R.id.text_content);
        this.setViewParams();
    }

    protected void setViewParams() {
        int paddingLeft = this.getContext().getResources().getDimensionPixelSize(R.dimen.platform_common_margin_size);
        this.setPadding(paddingLeft, 0, paddingLeft, 0);
    }

    protected int getContentLayoutId() {
        return R.layout.discover_common_forward_content_layout;
    }

    public void refreshForwardContent(ArticleInfo articleInfo) {
        if (this.mForwardContentText == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)articleInfo.content)) {
            return;
        }
        String title = articleInfo.content;
        SpannableString spannableString = new SpannableString((CharSequence)title);
        DiscoverSpanStringUtil.setStringArticleTopicHighlight((Spannable)spannableString, articleInfo.getArticleTopics());
        DiscoverSpanStringUtil.setStringArticleUserHighlight((Spannable)spannableString, articleInfo.getArticleATUsers());
        this.mForwardContentText.setText((CharSequence)spannableString);
    }
}

