/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.widget.article;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24ol.newclass.discover.util.RatioUtil;
import com.edu24ol.newclass.discover.widget.DefaultImageViewTarget;
import com.edu24ol.newclass.discover.widget.article.DiscoverUISetterVideoArticle;
import com.edu24ol.newclass.discover.widget.article.IArticleView;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.utils.DisplayUtils;
import com.hqwx.android.platform.utils.glide.tranform.SafeRoundedCorners;
import com.hqwx.android.playercontroller.ListVideoItemView;
import com.hqwx.android.service.difference.DifferenceConfig;
import com.yy.android.educommon.utils.TimeUtils;

public class DiscoverArticleViewVideo
extends ConstraintLayout
implements IArticleView<DiscoverArticleViewVideo> {
    protected ImageView mRecommendImg;
    TextView mVideoDurationTv;
    TextView mTitleView;
    private int mPictureRoundRadius;
    ListVideoItemView mListVideoItemView;
    protected DiscoverUISetterVideoArticle mUISetter;

    public DiscoverArticleViewVideo(@NonNull Context context) {
        super(context);
        this.initViews();
    }

    public DiscoverArticleViewVideo(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initViews();
    }

    public DiscoverArticleViewVideo(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initViews();
    }

    public void setUISetter(DiscoverUISetterVideoArticle uiSetterVideoArticle) {
        this.mUISetter = uiSetterVideoArticle;
    }

    protected void initViews() {
        View itemView = LayoutInflater.from((Context)this.getContext()).inflate(this.getContentLayoutId(), (ViewGroup)this, true);
        this.mRecommendImg = (ImageView)itemView.findViewById(R.id.item_discover_recommend_img);
        this.mPictureRoundRadius = DisplayUtils.dip2px((Context)this.getContext(), (float)2.0f);
        this.mTitleView = (TextView)itemView.findViewById(R.id.item_discover_recommend_title_view);
        this.mVideoDurationTv = (TextView)itemView.findViewById(R.id.tv_video_duration);
        this.setViewParams();
        this.mListVideoItemView = (ListVideoItemView)this.findViewById(R.id.item_video_view);
    }

    protected void setViewParams() {
        int paddingLeft = this.getContext().getResources().getDimensionPixelSize(R.dimen.platform_common_margin_size);
        this.setPadding(paddingLeft, 0, paddingLeft, 0);
    }

    protected int getContentLayoutId() {
        return R.layout.discover_item_article_view_video;
    }

    public void refreshArticleVideoContent(ArticleInfo articleInfo, int position) {
        if (DifferenceConfig.discoverDifferenceService.fixHeightVideoShow()) {
            ViewGroup.LayoutParams coverLayoutParams;
            int height;
            Pair<Integer, Integer> ratioPair = null;
            if (articleInfo.isVideoVerticalRatio() && articleInfo.isCoverVerticalRatio()) {
                int videoHeight = articleInfo.getVideoHeight();
                int videoWidth = articleInfo.getVideoWidth();
                ratioPair = RatioUtil.fixRatioUtil(this.getContext(), videoWidth, videoHeight);
            } else {
                int screenWidth = DisplayUtils.getScreenWidth((Context)this.getContext());
                height = (int)((float)screenWidth * 194.0f / 345.0f);
                ratioPair = RatioUtil.fixRatioUtil(this.getContext(), screenWidth, height);
            }
            int width = (Integer)ratioPair.first;
            height = (Integer)ratioPair.second;
            ViewGroup.LayoutParams layoutParams = this.mListVideoItemView.getLayoutParams();
            if (layoutParams != null) {
                layoutParams.height = height;
                layoutParams.width = width;
            }
            if ((coverLayoutParams = this.mRecommendImg.getLayoutParams()) != null) {
                coverLayoutParams.height = height;
                coverLayoutParams.width = width;
            }
        }
        this.mVideoDurationTv.setText((CharSequence)TimeUtils.makeTimeString((Context)this.getContext(), (long)articleInfo.getVideoDuration()));
        if (!TextUtils.isEmpty((CharSequence)articleInfo.getVideoCover())) {
            this.mRecommendImg.setVisibility(0);
            ((RequestBuilder)Glide.with((Context)this.getContext()).load(articleInfo.getVideoCover()).transform(new Transformation[]{new CenterCrop(), new SafeRoundedCorners(this.mPictureRoundRadius)})).apply(RequestOptions.diskCacheStrategyOf((DiskCacheStrategy)DiskCacheStrategy.ALL).dontAnimate()).into((Target)new DefaultImageViewTarget(this.mRecommendImg));
        }
        this.mListVideoItemView.setName(articleInfo.getVideoTitle());
        this.mListVideoItemView.setListPosition(position);
        this.mListVideoItemView.setTag(R.id.tag_position, (Object)position);
        this.mListVideoItemView.setTag((Object)articleInfo);
    }

    @Override
    public void refreshArticleInfo(ArticleInfo articleInfo, int position, boolean isShowTag) {
        if (this.mUISetter == null) {
            this.mUISetter = new DiscoverUISetterVideoArticle.NormalSetter();
        }
        this.mUISetter.setupVideoTitleView(this.mTitleView, articleInfo, isShowTag);
        this.refreshArticleVideoContent(articleInfo, position);
    }

    @Override
    public void setArticleEventListener(IArticleView.IArticleEventListener eventListener) {
    }

    @Override
    public void setViewVisible(boolean show) {
        this.setVisibility(show ? 0 : 8);
    }

    @Override
    public void setForwardUISetter() {
        this.setUISetter(new DiscoverUISetterVideoArticle.ForwardSetter());
    }

    @Override
    public DiscoverArticleViewVideo getRoot() {
        return this;
    }

    @Override
    public TextView getContentView() {
        return this.mTitleView;
    }
}

