/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.widget.article;

import android.content.Context;
import android.text.Layout;
import android.text.Spannable;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.CheckResult;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24.data.server.entity.GoodsGroupListBean;
import com.edu24ol.newclass.discover.util.DiscoverSpanStringUtil;
import com.edu24ol.newclass.discover.widget.ShortArticlePictureView;
import com.edu24ol.newclass.discover.widget.TextViewFixTouchConsume;
import com.edu24ol.newclass.discover.widget.article.DiscoverGoodsView;
import com.edu24ol.newclass.discover.widget.article.DiscoverUISetterShortArticle;
import com.edu24ol.newclass.discover.widget.article.IArticleView;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.utils.DisplayUtils;
import com.yy.android.educommon.log.YLog;
import java.util.List;

public class DiscoverArticleViewShort
extends ConstraintLayout
implements IArticleView<DiscoverArticleViewShort> {
    private DiscoverUISetterShortArticle mUISetter;
    protected TextViewFixTouchConsume mShortContentTitleView;
    protected TextView mShowTotalContentView;
    protected ShortArticlePictureView mShortArticlePictureView;
    protected DiscoverGoodsView mRecommendCourseView;
    protected int mShortDiscoverTitleWidth;
    private ArticleEventListener mArticleEventListener;

    public DiscoverArticleViewShort(@NonNull Context context) {
        super(context);
        this.initViews();
    }

    public DiscoverArticleViewShort(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initViews();
    }

    public DiscoverArticleViewShort(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initViews();
    }

    public void setUISetter(DiscoverUISetterShortArticle UISetter) {
        this.mUISetter = UISetter;
    }

    protected void initViews() {
        View itemView = LayoutInflater.from((Context)this.getContext()).inflate(this.getContentLayoutResourceId(), (ViewGroup)this, true);
        this.mShortContentTitleView = (TextViewFixTouchConsume)itemView.findViewById(R.id.item_discover_short_title_view);
        this.mShortContentTitleView.setMovementMethod((MovementMethod)TextViewFixTouchConsume.LocalLinkMovementMethod.getInstance());
        this.mShortContentTitleView.setFocusable(false);
        this.mShowTotalContentView = (TextView)itemView.findViewById(R.id.item_discover_short_show_total_view);
        this.mShortArticlePictureView = (ShortArticlePictureView)itemView.findViewById(R.id.picture_view);
        this.mShortArticlePictureView.setFocusableInTouchMode(false);
        this.mShortArticlePictureView.requestFocus();
        this.mRecommendCourseView = (DiscoverGoodsView)itemView.findViewById(R.id.item_discover_recommend_course_root_view);
        this.mRecommendCourseView.setOnClickListener(view -> {
            if (this.mArticleEventListener != null) {
                this.mArticleEventListener.onRecommendCourseClick((GoodsGroupListBean)view.getTag());
            }
        });
        this.mShortDiscoverTitleWidth = DisplayUtils.getScreenWidth((Context)this.getContext()) - this.getContext().getResources().getDimensionPixelSize(R.dimen.platform_common_margin_size) * 2;
        this.setViewParams();
    }

    protected void setViewParams() {
        int paddingLeft = this.getContext().getResources().getDimensionPixelSize(R.dimen.platform_common_margin_size);
        this.setPadding(paddingLeft, 0, paddingLeft, 0);
    }

    protected int getContentLayoutResourceId() {
        return R.layout.discover_item_article_view_short;
    }

    protected void showShortCourseView(ArticleInfo articleInfo) {
        if (articleInfo.goodsList != null && articleInfo.goodsList.size() > 0) {
            this.mRecommendCourseView.refreshCardView((GoodsGroupListBean)articleInfo.goodsList.get(0));
            this.mRecommendCourseView.setVisibility(0);
            this.mRecommendCourseView.setTag(articleInfo.goodsList.get(0));
        } else {
            this.mRecommendCourseView.setVisibility(8);
        }
    }

    protected void showShortPicView(ArticleInfo articleInfo) {
        List shortArticlePictures = articleInfo.shortArticlePictures;
        if (shortArticlePictures != null && shortArticlePictures.size() > 0) {
            this.mShortArticlePictureView.setVisibility(0);
            this.mShortArticlePictureView.setPicture(shortArticlePictures);
        } else {
            this.mShortArticlePictureView.setVisibility(8);
        }
    }

    public void refreshTitle(ArticleInfo articleInfo, boolean isShowTag) {
        if (this.mUISetter == null) {
            this.mUISetter = new DiscoverUISetterShortArticle.NormalSetter();
        }
        this.mUISetter.refreshTitle(this.mShowTotalContentView, (TextView)this.mShortContentTitleView, articleInfo, isShowTag, this.mShortDiscoverTitleWidth);
    }

    public static void setupTopicAndUserHighlight(ArticleInfo articleInfo, Spannable spannable) {
        DiscoverSpanStringUtil.setStringArticleTopicHighlight(spannable, articleInfo.getArticleTopics());
        DiscoverSpanStringUtil.setStringArticleUserHighlight(spannable, articleInfo.getArticleATUsers());
    }

    @Nullable
    @CheckResult
    public static String getCloseTextContent(TextView tv, int textViewLineWidth, int maxLine, String content) {
        if (textViewLineWidth < 0) {
            YLog.warn((Object)"", (String)"getCloseTextContent error,width: %d", (Object[])new Object[]{textViewLineWidth});
            return null;
        }
        int maxOffset = 8;
        TextPaint paint = tv.getPaint();
        StaticLayout staticLayout = new StaticLayout((CharSequence)content, paint, textViewLineWidth, Layout.Alignment.ALIGN_NORMAL, tv.getLineSpacingMultiplier(), 0.0f, false);
        if (staticLayout.getLineCount() > maxLine) {
            String lineText = content.substring(staticLayout.getLineStart(maxLine - 1), staticLayout.getLineStart(maxLine));
            float textWidth = paint.measureText(lineText);
            int offset = 0;
            float ratio = textWidth / (float)textViewLineWidth;
            if (ratio > 0.6f) {
                offset = (int)((float)maxOffset * ratio);
            }
            int index = staticLayout.getLineStart(maxLine);
            try {
                return content.substring(0, index - offset).trim() + "...";
            }
            catch (StringIndexOutOfBoundsException e) {
                YLog.error((Object)"", (String)"getCloseTextContent: ", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public void refreshArticleInfo(ArticleInfo articleInfo, int position, boolean isShowTag) {
        if (this.mUISetter == null) {
            this.mUISetter = new DiscoverUISetterShortArticle.NormalSetter();
        }
        this.refreshTitle(articleInfo, isShowTag);
        this.showShortPicView(articleInfo);
        this.showShortCourseView(articleInfo);
    }

    @Override
    public void setArticleEventListener(IArticleView.IArticleEventListener eventListener) {
        this.mArticleEventListener = (ArticleEventListener)eventListener;
    }

    @Override
    public void setViewVisible(boolean show) {
        this.setVisibility(show ? 0 : 8);
    }

    @Override
    public void setForwardUISetter() {
        this.setUISetter(new DiscoverUISetterShortArticle.ForwardSetter());
    }

    @Override
    public DiscoverArticleViewShort getRoot() {
        return this;
    }

    @Override
    public TextView getContentView() {
        return this.mShortContentTitleView;
    }

    public TextView getTotalContentView() {
        return this.mShowTotalContentView;
    }

    public static interface ArticleEventListener
    extends IArticleView.IArticleEventListener {
        public void onRecommendCourseClick(GoodsGroupListBean var1);
    }
}

