/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.widget.article;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24ol.newclass.discover.widget.DefaultImageViewTarget;
import com.edu24ol.newclass.discover.widget.article.DiscoverUISetterLongArticle;
import com.edu24ol.newclass.discover.widget.article.IArticleView;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.utils.DisplayUtils;
import com.hqwx.android.platform.utils.glide.tranform.SafeRoundedCorners;

public class DiscoverArticleViewLong
extends ConstraintLayout
implements IArticleView<DiscoverArticleViewLong> {
    protected ImageView mRecommendImg;
    protected TextView mDiscoverLongTitleView;
    protected TextView mSummary;
    private int mPictureRoundRadius;
    private DiscoverUISetterLongArticle mUISetterLongArticle;

    public DiscoverArticleViewLong(@NonNull Context context) {
        super(context);
        this.initViews();
    }

    public DiscoverArticleViewLong(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initViews();
    }

    public DiscoverArticleViewLong(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initViews();
    }

    public void setUISetter(DiscoverUISetterLongArticle UISetterLongArticle) {
        this.mUISetterLongArticle = UISetterLongArticle;
    }

    protected void initViews() {
        View itemView = LayoutInflater.from((Context)this.getContext()).inflate(this.getContentLayoutId(), (ViewGroup)this, true);
        this.mRecommendImg = (ImageView)itemView.findViewById(R.id.item_discover_recommend_img);
        this.mDiscoverLongTitleView = (TextView)itemView.findViewById(R.id.item_discover_recommend_title_view);
        this.mSummary = (TextView)itemView.findViewById(R.id.item_discover_recommend_summary);
        this.mPictureRoundRadius = DisplayUtils.dip2px((Context)this.getContext(), (float)2.0f);
        this.setViewParams();
    }

    protected void setViewParams() {
        int paddingLeft = this.getContext().getResources().getDimensionPixelSize(R.dimen.platform_common_margin_size);
        this.setPadding(paddingLeft, 0, paddingLeft, 0);
    }

    protected int getContentLayoutId() {
        return R.layout.discover_item_article_view_long;
    }

    protected void refreshArticleContent(ArticleInfo articleInfo) {
        if (!TextUtils.isEmpty((CharSequence)articleInfo.longPic)) {
            this.mRecommendImg.setVisibility(0);
            ((RequestBuilder)Glide.with((Context)this.getContext()).load(articleInfo.longPic).apply(RequestOptions.diskCacheStrategyOf((DiskCacheStrategy)DiskCacheStrategy.ALL).dontAnimate()).transform(new Transformation[]{new CenterCrop(), new SafeRoundedCorners(this.mPictureRoundRadius)})).into((Target)new DefaultImageViewTarget(this.mRecommendImg));
            this.mSummary.setVisibility(8);
        } else {
            if (!TextUtils.isEmpty((CharSequence)articleInfo.summary)) {
                this.mSummary.setVisibility(0);
                this.mSummary.setText((CharSequence)articleInfo.summary);
            } else {
                this.mSummary.setVisibility(8);
            }
            this.mRecommendImg.setVisibility(8);
        }
    }

    @Override
    public void refreshArticleInfo(ArticleInfo articleInfo, int position, boolean isShowTag) {
        if (this.mUISetterLongArticle == null) {
            this.mUISetterLongArticle = new DiscoverUISetterLongArticle.NormalSetter();
        }
        this.refreshArticleContent(articleInfo);
        this.mUISetterLongArticle.refreshTitle(this.mDiscoverLongTitleView, articleInfo, isShowTag);
    }

    @Override
    public void setArticleEventListener(IArticleView.IArticleEventListener eventListener) {
    }

    @Override
    public void setViewVisible(boolean show) {
        this.setVisibility(show ? 0 : 8);
    }

    @Override
    public void setForwardUISetter() {
        this.setUISetter(new DiscoverUISetterLongArticle.ForwardSetter());
    }

    @Override
    public DiscoverArticleViewLong getRoot() {
        return this;
    }

    @Override
    public TextView getContentView() {
        return this.mDiscoverLongTitleView;
    }
}

