/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.widget.article;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24ol.newclass.discover.widget.ShortArticlePictureView;
import com.edu24ol.newclass.discover.widget.article.DiscoverArticleViewShort;
import com.edu24ol.newclass.discover.widget.article.DiscoverUISetterFAQArticle;
import com.edu24ol.newclass.discover.widget.article.IArticleView;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.utils.DisplayUtils;
import java.util.List;

public class DiscoverArticleViewFAQ
extends ConstraintLayout
implements IArticleView<DiscoverArticleViewFAQ> {
    private DiscoverUISetterFAQArticle mUISetter;
    protected TextView mTitleView;
    protected TextView mQuestionContentView;
    protected TextView mAnswerContentView;
    protected ShortArticlePictureView mShortArticlePictureView;
    protected TextView mShowTotalContentView;
    protected int mShortDiscoverTitleWidth;
    private DiscoverArticleViewShort.ArticleEventListener mArticleEventListener;

    public DiscoverArticleViewFAQ(@NonNull Context context) {
        super(context);
        this.initViews();
    }

    public DiscoverArticleViewFAQ(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initViews();
    }

    public DiscoverArticleViewFAQ(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initViews();
    }

    public void setUISetter(DiscoverUISetterFAQArticle UISetterShortArticle) {
        this.mUISetter = UISetterShortArticle;
    }

    protected void initViews() {
        View itemView = LayoutInflater.from((Context)this.getContext()).inflate(this.getContentLayoutResourceId(), (ViewGroup)this, true);
        this.mTitleView = (TextView)itemView.findViewById(R.id.title_view);
        this.mQuestionContentView = (TextView)itemView.findViewById(R.id.question_content_view);
        this.mAnswerContentView = (TextView)itemView.findViewById(R.id.answer_content_view);
        this.mShortArticlePictureView = (ShortArticlePictureView)itemView.findViewById(R.id.picture_view);
        this.mShortArticlePictureView.setFocusableInTouchMode(false);
        this.mShortArticlePictureView.requestFocus();
        this.mShowTotalContentView = (TextView)itemView.findViewById(R.id.show_total_view);
        this.mShortDiscoverTitleWidth = DisplayUtils.getScreenWidth((Context)this.getContext()) - this.getContext().getResources().getDimensionPixelSize(R.dimen.platform_common_margin_size) * 2;
        this.setViewParams();
    }

    protected void setViewParams() {
        int paddingLeft = this.getContext().getResources().getDimensionPixelSize(R.dimen.platform_common_margin_size);
        this.setPadding(paddingLeft, 0, paddingLeft, 0);
    }

    protected int getContentLayoutResourceId() {
        return R.layout.discover_item_article_view_faq;
    }

    protected void showPictureView(ArticleInfo articleInfo) {
        List shortArticlePictures = articleInfo.shortArticlePictures;
        if (shortArticlePictures != null && shortArticlePictures.size() > 0) {
            this.mShortArticlePictureView.setVisibility(0);
            this.mShortArticlePictureView.setPicture(shortArticlePictures);
        } else {
            this.mShortArticlePictureView.setVisibility(8);
        }
    }

    @Override
    public void refreshArticleInfo(ArticleInfo articleInfo, int position, boolean isShowTag) {
        if (this.mUISetter == null) {
            this.mUISetter = new DiscoverUISetterFAQArticle.NormalSetter();
        }
        this.mUISetter.refreshTitle(this.mTitleView, articleInfo, isShowTag);
        this.mUISetter.refreshContent(this.mShowTotalContentView, this.mQuestionContentView, articleInfo, this.mShortDiscoverTitleWidth);
        this.showPictureView(articleInfo);
        if (articleInfo.getArticleFAQ() != null) {
            this.mAnswerContentView.setText((CharSequence)("\u6559\u7814\u8001\u5e08\uff1a " + articleInfo.getArticleFAQ().getContentText()));
            this.mAnswerContentView.setVisibility(0);
        } else {
            this.mAnswerContentView.setVisibility(8);
        }
    }

    @Override
    public void setArticleEventListener(IArticleView.IArticleEventListener eventListener) {
        this.mArticleEventListener = (DiscoverArticleViewShort.ArticleEventListener)eventListener;
    }

    @Override
    public void setViewVisible(boolean show) {
        this.setVisibility(show ? 0 : 8);
    }

    @Override
    public void setForwardUISetter() {
        this.setUISetter(new DiscoverUISetterFAQArticle.ForwardSetter());
    }

    @Override
    public DiscoverArticleViewFAQ getRoot() {
        return this;
    }

    @Override
    public TextView getContentView() {
        return null;
    }

    public static interface ArticleEventListener
    extends IArticleView.IArticleEventListener {
    }
}

