/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.widget.article;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24.data.server.entity.GoodsGroupListBean;
import com.edu24ol.newclass.discover.widget.article.DiscoverGoodsView;
import com.edu24ol.newclass.discover.widget.article.DiscoverUISetterCommentArticle;
import com.edu24ol.newclass.discover.widget.article.IArticleView;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.widgets.ratingbar.AndRatingBar;

public class DiscoverArticleViewComment
extends ConstraintLayout
implements IArticleView<DiscoverArticleViewComment> {
    private DiscoverUISetterCommentArticle mUISetter;
    protected TextView mForwardTextView;
    protected TextView mTitleView;
    protected TextView mContentView;
    protected DiscoverGoodsView mCommentCourseView;
    protected AndRatingBar mRatingBar;
    private ArticleEventListener mArticleEventListener;

    public DiscoverArticleViewComment(@NonNull Context context) {
        super(context);
        this.initViews();
    }

    public DiscoverArticleViewComment(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initViews();
    }

    public DiscoverArticleViewComment(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initViews();
    }

    public void setUISetter(DiscoverUISetterCommentArticle UISetter) {
        this.mUISetter = UISetter;
    }

    protected void initViews() {
        View itemView = LayoutInflater.from((Context)this.getContext()).inflate(this.getContentLayoutResourceId(), (ViewGroup)this, true);
        this.mForwardTextView = (TextView)itemView.findViewById(R.id.forward_text_view);
        this.mTitleView = (TextView)itemView.findViewById(R.id.title_view);
        this.mContentView = (TextView)itemView.findViewById(R.id.content_view);
        this.mRatingBar = (AndRatingBar)itemView.findViewById(R.id.rb_course_evaluate);
        this.mCommentCourseView = (DiscoverGoodsView)itemView.findViewById(R.id.course_root_view);
        this.mCommentCourseView.setOnClickListener(view -> {
            if (this.mArticleEventListener != null) {
                this.mArticleEventListener.onCourseClick((GoodsGroupListBean)view.getTag());
            }
        });
        this.mRatingBar.setIsIndicator(true);
        this.setViewParams();
    }

    protected void setViewParams() {
        int paddingLeft = this.getContext().getResources().getDimensionPixelSize(R.dimen.platform_common_margin_size);
        this.setPadding(paddingLeft, 0, paddingLeft, 0);
    }

    protected int getContentLayoutResourceId() {
        return R.layout.discover_item_article_view_comment;
    }

    protected void showShortCourseView(ArticleInfo articleInfo) {
        if (articleInfo.commentGoods != null && articleInfo.commentGoods.size() > 0) {
            this.mCommentCourseView.refreshCardView((GoodsGroupListBean)articleInfo.commentGoods.get(0));
            this.mCommentCourseView.setVisibility(0);
            this.mCommentCourseView.setTag(articleInfo.commentGoods.get(0));
        } else {
            this.mCommentCourseView.setVisibility(8);
        }
    }

    @Override
    public void refreshArticleInfo(ArticleInfo articleInfo, int position, boolean isShowTag) {
        if (this.mUISetter == null) {
            this.mUISetter = new DiscoverUISetterCommentArticle.NormalSetter();
        }
        this.mUISetter.refreshForwardTitle(this.mForwardTextView, articleInfo);
        if (articleInfo.getArticleCourseComment() != null) {
            this.mRatingBar.setRating(articleInfo.getArticleCourseComment().getStar());
        }
        this.mContentView.setText((CharSequence)articleInfo.content);
        this.showShortCourseView(articleInfo);
    }

    @Override
    public void setArticleEventListener(IArticleView.IArticleEventListener eventListener) {
        this.mArticleEventListener = (ArticleEventListener)eventListener;
    }

    @Override
    public void setViewVisible(boolean show) {
        this.setVisibility(show ? 0 : 8);
    }

    @Override
    public void setForwardUISetter() {
        this.setUISetter(new DiscoverUISetterCommentArticle.ForwardSetter());
    }

    @Override
    public DiscoverArticleViewComment getRoot() {
        return this;
    }

    @Override
    public TextView getContentView() {
        return null;
    }

    public static interface ArticleEventListener
    extends IArticleView.IArticleEventListener {
        public void onCourseClick(GoodsGroupListBean var1);
    }
}

