/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.widget.article;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.utils.DisplayUtils;
import com.hqwx.android.platform.widgets.CircleImageView;
import com.hqwx.android.service.difference.DifferenceConfig;
import com.yy.android.educommon.utils.TimeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiscoverArticleHeaderView
extends ConstraintLayout {
    protected View mBaseHeaderRootLayoutView;
    protected CircleImageView mBaseHeaderAuthorHeaderView;
    protected TextView mBaseHeaderAuthorHeaderNameView;
    protected TextView mBaseHeaderAuthorTimeDescView;
    protected ImageView mVIcon;
    protected CheckBox mAttentionCb;
    protected ImageView mMoreIcon;
    private boolean isShowAttentionView = true;
    private boolean enableCancelAttention = false;
    private EventClickListener mEventClickListener;

    public void setEnableCancelAttention(boolean enableCancelAttention) {
        this.enableCancelAttention = enableCancelAttention;
    }

    public DiscoverArticleHeaderView(@NonNull @NotNull Context context) {
        this(context, null);
    }

    public DiscoverArticleHeaderView(@NonNull @NotNull Context context, @androidx.annotation.Nullable @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DiscoverArticleHeaderView(@NonNull @NotNull Context context, @androidx.annotation.Nullable @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    protected void initView() {
        View itemView;
        this.mBaseHeaderRootLayoutView = itemView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.discover_item_common_header_layout, (ViewGroup)this, true);
        this.mBaseHeaderAuthorHeaderView = (CircleImageView)itemView.findViewById(R.id.header_discover_publish_header_view);
        this.mBaseHeaderAuthorHeaderNameView = (TextView)itemView.findViewById(R.id.header_discover_publish_name_view);
        this.mBaseHeaderAuthorTimeDescView = (TextView)itemView.findViewById(R.id.header_discover_publish_time_desc_view);
        this.mMoreIcon = (ImageView)itemView.findViewById(R.id.icon_more);
        this.mVIcon = (ImageView)itemView.findViewById(R.id.icon_v);
        this.setClipToPadding(false);
        this.setClipChildren(false);
        this.mAttentionCb = (CheckBox)itemView.findViewById(R.id.cb_header_discover_attention);
        this.mAttentionCb.setOnClickListener(v -> {
            if (this.mEventClickListener != null) {
                this.mEventClickListener.onAttentionClick(this.mAttentionCb);
            }
        });
        this.mMoreIcon.setOnClickListener(v -> {
            if (this.mEventClickListener != null) {
                this.mEventClickListener.onMoreClick(v);
            }
        });
        this.setViewParams();
        if (DifferenceConfig.discoverDifferenceService.isHideDiscoverCellInteractive()) {
            this.mMoreIcon.setVisibility(8);
            this.mAttentionCb.setVisibility(8);
        }
    }

    protected void setViewParams() {
        int paddingLeft = this.getContext().getResources().getDimensionPixelSize(R.dimen.platform_common_margin_size);
        int paddingTop = DisplayUtils.dip2px((Context)this.getContext(), (float)16.0f);
        int paddingBottom = DisplayUtils.dip2px((Context)this.getContext(), (float)8.0f);
        this.setPadding(paddingLeft, paddingTop, paddingLeft, paddingBottom);
    }

    public void setEventClickListener(EventClickListener eventClickListener) {
        this.mEventClickListener = eventClickListener;
    }

    public void refresh(ArticleInfo articleInfo) {
        if (articleInfo.author != null) {
            ((RequestBuilder)((RequestBuilder)((RequestBuilder)Glide.with((Context)this.getContext()).load(articleInfo.author.pic).placeholder(R.mipmap.default_ic_avatar)).dontAnimate()).centerCrop()).into((ImageView)this.mBaseHeaderAuthorHeaderView);
            this.mBaseHeaderAuthorHeaderNameView.setText((CharSequence)articleInfo.author.name);
            if (articleInfo.author.isV()) {
                this.mVIcon.setVisibility(0);
            } else {
                this.mVIcon.setVisibility(8);
            }
            this.mBaseHeaderAuthorTimeDescView.setMaxWidth(DisplayUtils.getScreenWidth((Context)this.getContext()) - DisplayUtils.dip2px((Context)this.getContext(), (float)60.0f));
            String description = "";
            if (!TextUtils.isEmpty((CharSequence)articleInfo.author.description)) {
                description = " \u00b7 " + articleInfo.author.description;
            }
            this.mBaseHeaderAuthorTimeDescView.setText((CharSequence)(TimeUtils.transformArticleTime((long)articleInfo.publishTime) + description));
        } else {
            this.mBaseHeaderAuthorTimeDescView.setText((CharSequence)TimeUtils.transformArticleTime((long)articleInfo.publishTime));
            this.mBaseHeaderAuthorHeaderView.setImageResource(R.mipmap.default_ic_avatar);
            this.mBaseHeaderAuthorHeaderNameView.setText((CharSequence)"");
        }
        this.refreshAttentionState(articleInfo);
    }

    public void refreshAttentionState(ArticleInfo articleInfo) {
        if (DifferenceConfig.discoverDifferenceService.isHideDiscoverCellInteractive()) {
            this.isShowAttentionView = false;
        }
        if (this.isShowAttentionView && articleInfo.author != null) {
            if (articleInfo.author.isAttendAuthor()) {
                this.mAttentionCb.setText((CharSequence)"\u5df2\u5173\u6ce8");
                this.mAttentionCb.setSelected(true);
                if (!this.enableCancelAttention) {
                    this.mAttentionCb.setVisibility(4);
                }
            } else {
                this.mAttentionCb.setText((CharSequence)"+ \u5173\u6ce8");
                this.mAttentionCb.setSelected(false);
                this.mAttentionCb.setVisibility(0);
            }
            this.mAttentionCb.setTag((Object)articleInfo.author);
        }
    }

    public void showAttentionView(boolean isShow) {
        this.isShowAttentionView = isShow;
        this.mAttentionCb.setVisibility(isShow ? 0 : 8);
    }

    public void showMoreView(boolean isShow) {
        if (DifferenceConfig.discoverDifferenceService.isHideDiscoverCellInteractive()) {
            isShow = false;
        }
        this.mMoreIcon.setVisibility(isShow ? 0 : 8);
        int paddingLeft = this.getContext().getResources().getDimensionPixelSize(R.dimen.platform_common_margin_size);
        if (isShow) {
            this.setPadding(paddingLeft, this.getPaddingTop(), paddingLeft, this.getPaddingBottom());
        } else {
            this.setPadding(paddingLeft, this.getPaddingTop(), DisplayUtils.dip2px((Context)this.getContext(), (float)10.0f), this.getPaddingBottom());
        }
    }

    public void onSetAuthorNameTextSize(float size) {
        if (this.mBaseHeaderAuthorHeaderNameView != null) {
            this.mBaseHeaderAuthorHeaderNameView.setTextSize(2, size);
        }
    }

    public void onSetAuthorNameTextStyle(boolean fakeBoldText) {
        if (this.mBaseHeaderAuthorHeaderNameView != null) {
            this.mBaseHeaderAuthorHeaderNameView.getPaint().setFakeBoldText(fakeBoldText);
        }
    }

    public void onSetAuthorNameTextColor(int color2) {
        if (this.mBaseHeaderAuthorHeaderNameView != null) {
            this.mBaseHeaderAuthorHeaderNameView.setTextColor(color2);
        }
    }

    public static interface EventClickListener {
        public void onMoreClick(View var1);

        public void onAttentionClick(CheckBox var1);
    }
}

