/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.widget.article;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24.data.server.discover.entity.ArticleTopic;
import com.edu24ol.newclass.discover.widget.ImageCountFuncView;
import com.edu24ol.newclass.discover.widget.article.DiscoverTopicContentView;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.service.difference.DifferenceConfig;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiscoverArticleFooterView
extends LinearLayout {
    protected ImageCountFuncView mShareFuncView;
    protected ImageCountFuncView mEvaluateFuncView;
    protected ImageCountFuncView mPraiseFuncView;
    protected DiscoverTopicContentView mDiscoverTopicContentView;
    protected boolean isEnableTopic = true;
    private EventClickListener mEventClickListener;

    public DiscoverArticleFooterView(@NonNull @NotNull Context context) {
        this(context, null);
    }

    public DiscoverArticleFooterView(@NonNull @NotNull Context context, @androidx.annotation.Nullable @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DiscoverArticleFooterView(@NonNull @NotNull Context context, @androidx.annotation.Nullable @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
        this.setViewParams();
    }

    protected void setViewParams() {
        int paddingLeft = this.getContext().getResources().getDimensionPixelSize(R.dimen.platform_common_margin_size);
        this.setPadding(paddingLeft, 0, paddingLeft, 0);
    }

    protected void initView() {
        this.setOrientation(1);
        View itemView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.discover_item_common_footer_layout, (ViewGroup)this, true);
        View llfooterCoonainer = itemView.findViewById(R.id.ll_footer_container);
        View bottomSeatLayout = itemView.findViewById(R.id.bottom_seat_layout);
        this.mShareFuncView = (ImageCountFuncView)itemView.findViewById(R.id.footer_share_view);
        this.mEvaluateFuncView = (ImageCountFuncView)itemView.findViewById(R.id.footer_evaluate_view);
        this.mPraiseFuncView = (ImageCountFuncView)itemView.findViewById(R.id.footer_praise_view);
        this.mPraiseFuncView.setImageSource(R.mipmap.discover_common_item_bottom_not_parise_ic);
        this.mEvaluateFuncView.setImageSource(R.mipmap.discover_common_item_bottom_comment_ic);
        this.mShareFuncView.setImageSource(R.mipmap.discover_common_item_bottom_share_ic);
        this.mShareFuncView.setOnClickListener(v -> {
            if (this.mEventClickListener != null) {
                this.mEventClickListener.onShareClick(v);
            }
        });
        this.mEvaluateFuncView.setOnClickListener(v -> {
            if (this.mEventClickListener != null) {
                this.mEventClickListener.onEvaluateClick(v);
            }
        });
        this.mPraiseFuncView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (DiscoverArticleFooterView.this.mEventClickListener != null) {
                    DiscoverArticleFooterView.this.mEventClickListener.onPraiseClick(v);
                }
            }
        });
        this.mDiscoverTopicContentView = (DiscoverTopicContentView)itemView.findViewById(R.id.topic_view);
        if (DifferenceConfig.discoverDifferenceService.isHideDiscoverCellInteractive()) {
            this.mDiscoverTopicContentView.setVisibility(8);
            llfooterCoonainer.setVisibility(8);
            bottomSeatLayout.setVisibility(0);
        }
    }

    public void setEnableTopic(boolean enableTopic) {
        this.isEnableTopic = enableTopic;
    }

    public void setTopicData(List<ArticleTopic> topicList) {
        if (this.isEnableTopic && topicList != null && topicList.size() > 0) {
            this.mDiscoverTopicContentView.setTopicData(topicList);
            this.mDiscoverTopicContentView.setVisibility(0);
        } else {
            this.mDiscoverTopicContentView.setVisibility(8);
        }
    }

    public void setTopicClickListener(View.OnClickListener topicClickListener) {
        this.mDiscoverTopicContentView.setTopicClickListener(topicClickListener);
    }

    public void setEventClickListener(EventClickListener eventClickListener) {
        this.mEventClickListener = eventClickListener;
    }

    public void refresh(ArticleInfo articleInfo) {
        this.refreshEvaluateState(articleInfo);
        this.refreshShareState(articleInfo);
        this.refreshPraiseState(articleInfo);
    }

    public void refreshPraiseState(ArticleInfo articleInfo) {
        if (articleInfo.pointsCount > 0) {
            this.mPraiseFuncView.setTextViewText(String.valueOf(articleInfo.pointsCount));
            this.mPraiseFuncView.setTextViewVisible(true);
        } else {
            this.mPraiseFuncView.setTextViewVisible(false);
        }
        if (articleInfo.isLikeArticle()) {
            this.mPraiseFuncView.setImageSource(R.mipmap.discover_common_item_bottom_parise_ic);
        } else {
            this.mPraiseFuncView.setImageSource(R.mipmap.discover_common_item_bottom_not_parise_ic);
        }
    }

    public void refreshEvaluateState(ArticleInfo articleInfo) {
        if (articleInfo.replyCount > 0) {
            this.mEvaluateFuncView.setTextViewText(String.valueOf(articleInfo.replyCount));
            this.mEvaluateFuncView.setTextViewVisible(true);
        } else {
            this.mEvaluateFuncView.setTextViewVisible(false);
        }
    }

    public void refreshShareState(ArticleInfo articleInfo) {
        this.mShareFuncView.setTextViewText("\u5206\u4eab");
    }

    public void refreshForwardState(ArticleInfo articleInfo) {
    }

    public static interface EventClickListener {
        public void onShareClick(View var1);

        public void onEvaluateClick(View var1);

        public void onPraiseClick(View var1);
    }
}

