/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.edu24.data.server.discover.entity.ArticleImage;
import com.edu24ol.newclass.discover.adapter.DiscoverShortPicListAdapter;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.utils.DisplayUtils;
import com.hqwx.android.platform.widgets.RecycleViewGridItemDecoration;
import java.util.List;

public class ShortArticlePictureView
extends RecyclerView {
    private DiscoverShortPicListAdapter mAdapter;

    public ShortArticlePictureView(@NonNull Context context) {
        super(context);
    }

    public ShortArticlePictureView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ShortArticlePictureView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setPicture(List<ArticleImage> pictures) {
        GridLayoutManager gridLayoutManager;
        if (pictures == null) {
            return;
        }
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (pictures.size() > 1) {
            boolean isThirdTimeCount = pictures.size() != 2 && pictures.size() != 4;
            gridLayoutManager = new GridLayoutManager(this.getContext(), isThirdTimeCount ? 3 : 2);
            int pictureMaxWidth = DisplayUtils.getScreenWidth((Context)this.getContext()) - this.getContext().getResources().getDimensionPixelSize(R.dimen.platform_common_margin_size) * 2;
            layoutParams.width = isThirdTimeCount ? pictureMaxWidth : pictureMaxWidth - (pictureMaxWidth - DisplayUtils.dip2px((Context)this.getContext(), (float)5.0f) * 2) / 3;
        } else {
            gridLayoutManager = new GridLayoutManager(this.getContext(), 1);
            layoutParams.width = -2;
        }
        layoutParams.height = -2;
        this.setLayoutParams(layoutParams);
        gridLayoutManager.setAutoMeasureEnabled(true);
        this.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
        if (this.mAdapter == null) {
            this.mAdapter = new DiscoverShortPicListAdapter(this.getContext());
            this.mAdapter.setDatas(pictures);
            this.mAdapter.setOnGetSizeListener((parentWidth, parentHeight) -> {
                ViewGroup.LayoutParams layoutParams1 = this.getLayoutParams();
                layoutParams1.width = parentWidth;
                layoutParams1.height = parentHeight;
                this.setLayoutParams(layoutParams1);
            });
            this.setAdapter(this.mAdapter);
        } else {
            this.mAdapter = (DiscoverShortPicListAdapter)this.getAdapter();
            this.mAdapter.setDatas(pictures);
            this.mAdapter.notifyDataSetChanged();
        }
        if (this.getItemDecorationCount() == 0) {
            int space = DisplayUtils.dip2px((Context)this.getContext(), (float)5.0f);
            RecycleViewGridItemDecoration gridImgItemDecoration = new RecycleViewGridItemDecoration(space, space);
            this.addItemDecoration((RecyclerView.ItemDecoration)gridImgItemDecoration);
        }
    }
}

