/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.hqwx.android.discover.common.R;

public class DiscoverRecommendItemDecoration
extends RecyclerView.ItemDecoration {
    private Drawable mDivider;
    private Paint mPaint;
    private int mHeightDp;

    public DiscoverRecommendItemDecoration(Context context) {
        this.mDivider = context.getResources().getDrawable(R.drawable.platform_shape_list_divider);
    }

    public DiscoverRecommendItemDecoration(Context context, int color2, int heightDp) {
        this.mPaint = new Paint();
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(color2);
        this.mHeightDp = heightDp;
    }

    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        int position = parent.getChildAdapterPosition(view);
        int viewType = parent.getAdapter().getItemViewType(position);
        if (viewType != -1) {
            outRect.set(0, 0, 0, this.mHeightDp);
        } else {
            outRect.setEmpty();
        }
    }

    private boolean hasDividerOnBottom(View view, RecyclerView parent, RecyclerView.State state) {
        int position = ((RecyclerView.LayoutParams)view.getLayoutParams()).getViewAdapterPosition();
        return position < state.getItemCount() && parent.getAdapter().getItemViewType(position) != -1;
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            View view = parent.getChildAt(i);
            if (!this.hasDividerOnBottom(view, parent, state)) continue;
            c.drawRect((float)view.getLeft(), (float)view.getBottom(), (float)view.getRight(), (float)(view.getBottom() + this.mHeightDp), this.mPaint);
        }
    }
}

