/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.widget;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24ol.newclass.discover.util.DiscoverUserHelper;
import com.hqwx.android.discover.common.databinding.DiscoverMenuItemPopwindowBinding;
import com.hqwx.android.platform.utils.DisplayUtils;
import com.hqwx.android.platform.widgets.HqPopupWindow;

public class DiscoverItemMenuWindow
extends HqPopupWindow {
    private DiscoverMenuItemPopwindowBinding mBinding;
    private Context mContext;
    private MenuItemClickListener mMenuItemClickListener;

    public DiscoverItemMenuWindow(ArticleInfo articleInfo, Context context) {
        super(context);
        this.mContext = context;
        this.setWidth(-2);
        this.setHeight(-2);
        this.mBinding = DiscoverMenuItemPopwindowBinding.inflate(LayoutInflater.from((Context)this.mContext));
        this.setContentView((View)this.mBinding.getRoot());
        this.setTouchable(true);
        this.setOutsideTouchable(true);
        this.setClippingEnabled(false);
        boolean isArticleOwner = articleInfo.isCurrentLoginUserEqualAuthor(DiscoverUserHelper.getUserId());
        if (isArticleOwner) {
            this.mBinding.reportView.setVisibility(8);
        } else {
            this.mBinding.deleteView.setVisibility(8);
        }
        this.mBinding.line2.setVisibility(8);
        this.mBinding.shareView.setOnClickListener(view -> {
            if (this.mMenuItemClickListener != null) {
                this.mMenuItemClickListener.onShareClick();
            }
            this.dismiss();
        });
        this.mBinding.reportView.setOnClickListener(view -> {
            if (this.mMenuItemClickListener != null) {
                this.mMenuItemClickListener.onReportClick();
            }
            this.dismiss();
        });
        this.mBinding.deleteView.setOnClickListener(view -> {
            if (this.mMenuItemClickListener != null) {
                this.mMenuItemClickListener.onDeleteClick();
            }
            this.dismiss();
        });
        this.setOnDismissListener(() -> this.changeWindowAlpha(1.0f));
    }

    public void show(View anchor) {
        View contentView = this.getContentView();
        contentView.measure(DiscoverItemMenuWindow.makeDropDownMeasureSpec(this.getWidth()), DiscoverItemMenuWindow.makeDropDownMeasureSpec(this.getHeight()));
        int width = contentView.getMeasuredWidth();
        int triangleX = width / 2 - 116 * width / 424;
        int xOff = anchor.getWidth() / 2 - width / 2 - triangleX;
        this.showAsDropDown(anchor, xOff, 0 - DisplayUtils.dip2px((Context)this.mContext, (float)12.0f));
        this.changeWindowAlpha(1.0f);
    }

    private static int makeDropDownMeasureSpec(int measureSpec) {
        int mode = measureSpec == -2 ? 0 : 0x40000000;
        return View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)measureSpec), (int)mode);
    }

    public void setMenuItemClickListener(MenuItemClickListener menuItemClickListener) {
        this.mMenuItemClickListener = menuItemClickListener;
    }

    private void changeWindowAlpha(float toAlpha) {
        Window window = ((Activity)this.mContext).getWindow();
        WindowManager.LayoutParams attributes = window.getAttributes();
        attributes.flags |= 2;
        attributes.dimAmount = toAlpha;
        attributes.alpha = toAlpha;
        window.setAttributes(attributes);
    }

    protected int getWindowWidth() {
        return -2;
    }

    public static interface MenuItemClickListener {
        public void onShareClick();

        public void onReportClick();

        public void onDeleteClick();
    }
}

