/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

public class CommonItemDecoration
extends RecyclerView.ItemDecoration {
    private Drawable mDivider;
    private Paint mPaint = new Paint();
    private int mHeightDp;
    private int mMargin;

    public CommonItemDecoration(Context context, int color2, int heightDp, int margin) {
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(color2);
        this.mHeightDp = heightDp;
        this.mMargin = margin;
    }

    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        int position = parent.getChildAdapterPosition(view);
        int itemCount = parent.getAdapter().getItemCount();
        if (itemCount > 1) {
            if (position == 0) {
                outRect.set(0, 0, 0, this.mHeightDp + this.mMargin);
            } else if (position == itemCount - 1) {
                outRect.set(0, this.mMargin, 0, 0);
            } else {
                outRect.set(0, this.mMargin, 0, this.mHeightDp + this.mMargin);
            }
        }
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        int count = parent.getChildCount();
        if (count > 1) {
            for (int i = 0; i < count; ++i) {
                View view = parent.getChildAt(i);
                c.drawRect((float)view.getLeft(), (float)(view.getBottom() + this.mMargin), (float)view.getRight(), (float)(view.getBottom() + this.mMargin + this.mHeightDp), this.mPaint);
            }
        }
    }
}

