/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.viewholder;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24.data.server.discover.entity.ArticleTopic;
import com.edu24ol.newclass.discover.viewholder.DiscoverArticleEvent;
import com.edu24ol.newclass.discover.viewholder.DiscoverBaseArticleItemViewHolder;
import com.edu24ol.newclass.discover.widget.article.DiscoverArticleFooterView;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.stat.Referrer;
import com.hqwx.android.service.AppRouter;
import com.hqwx.android.service.difference.DifferenceConfig;
import java.util.List;

public class DiscoverBaseArticleListItemViewHolder<K extends ViewGroup>
extends DiscoverBaseArticleItemViewHolder<K> {
    protected DiscoverArticleFooterView mFooterView;
    protected DiscoverArticleEvent.CommonEventListener mCommonEventListener;
    protected DiscoverArticleEvent.FooterEventListener mFooterEventListener;

    public DiscoverBaseArticleListItemViewHolder(Context context, View itemView) {
        super(context, itemView);
        this.mFooterView = this.getArticleFooterView(itemView);
        this.initListener();
    }

    protected DiscoverArticleFooterView getArticleFooterView(View itemView) {
        return (DiscoverArticleFooterView)itemView.findViewById(R.id.discover_footer_view);
    }

    protected void initListener() {
        this.mFooterView.setEventClickListener(new DiscoverArticleFooterView.EventClickListener(){

            @Override
            public void onShareClick(View view) {
                ArticleInfo articleInfo = (ArticleInfo)DiscoverBaseArticleListItemViewHolder.this.itemView.getTag();
                if (articleInfo == null) {
                    return;
                }
                if (DiscoverBaseArticleListItemViewHolder.this.mFooterEventListener != null) {
                    DiscoverBaseArticleListItemViewHolder.this.mFooterEventListener.onShareArticleClick(articleInfo);
                }
            }

            @Override
            public void onEvaluateClick(View view) {
                ArticleInfo articleInfo = (ArticleInfo)DiscoverBaseArticleListItemViewHolder.this.itemView.getTag();
                if (articleInfo == null) {
                    return;
                }
                if (DiscoverBaseArticleListItemViewHolder.this.mFooterEventListener != null) {
                    int position;
                    articleInfo.postion = position = ((Integer)DiscoverBaseArticleListItemViewHolder.this.itemView.getTag(R.id.tag_position)).intValue();
                    DiscoverBaseArticleListItemViewHolder.this.mFooterEventListener.onEvaluateArticleClick(articleInfo);
                }
            }

            @Override
            public void onPraiseClick(View view) {
                ArticleInfo articleInfo = (ArticleInfo)DiscoverBaseArticleListItemViewHolder.this.itemView.getTag();
                if (articleInfo == null) {
                    return;
                }
                int position = (Integer)DiscoverBaseArticleListItemViewHolder.this.itemView.getTag(R.id.tag_position);
                if (DiscoverBaseArticleListItemViewHolder.this.mFooterEventListener != null) {
                    DiscoverBaseArticleListItemViewHolder.this.mFooterEventListener.onPraiseArticleClick(articleInfo, position);
                }
            }
        });
        this.mFooterView.setTopicClickListener(v -> {
            if (v.getTag() == null) {
                return;
            }
            ArticleTopic topic = (ArticleTopic)v.getTag();
            AppRouter.startDiscoverTopicDetailActivity((Context)v.getContext(), (long)topic.getId(), (String)Referrer.getInstance().getCurrentFragmentPageName(), (String)"\u5185\u5bb9\u8be6\u60c5\u9875");
        });
        this.itemView.setOnClickListener(v -> {
            ArticleInfo articleInfo = (ArticleInfo)this.itemView.getTag();
            if (articleInfo == null) {
                return;
            }
            if (DifferenceConfig.discoverDifferenceService.isHideDiscoverCellInteractive()) {
                return;
            }
            if (this.mCommonEventListener != null) {
                int position;
                articleInfo.postion = position = ((Integer)this.itemView.getTag(R.id.tag_position)).intValue();
                this.mCommonEventListener.onArticleItemClick(articleInfo);
            }
        });
    }

    @Override
    public void onBindViewHolder(Context context, ArticleInfo articleInfo, int position) {
        super.onBindViewHolder(context, articleInfo, position);
        this.mFooterView.refresh(articleInfo);
        this.mFooterView.setTopicData(articleInfo.getArticleTopics());
    }

    @Override
    public void onBindViewHolder(Context context, ArticleInfo articleInfo, List payloads, int position) {
        super.onBindViewHolder(context, articleInfo, payloads, position);
        String payLoad = (String)payloads.get(0);
        if ("praise".equals(payLoad)) {
            this.mFooterView.refreshPraiseState(articleInfo);
        } else if ("replayCount".equals(payLoad)) {
            this.mFooterView.refreshEvaluateState(articleInfo);
        } else if ("shareCount".equals(payLoad)) {
            this.mFooterView.refreshShareState(articleInfo);
        } else if ("transmitCount".equals(payLoad)) {
            this.mFooterView.refreshForwardState(articleInfo);
        }
    }

    public void setCommonEventListener(DiscoverArticleEvent.CommonEventListener commonEventListener) {
        this.mCommonEventListener = commonEventListener;
    }

    public void setFooterEventListener(DiscoverArticleEvent.FooterEventListener footerEventListener) {
        this.mFooterEventListener = footerEventListener;
    }
}

